/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.AdditionalRecipientReceivableRefund;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a monetary distribution of part of a [Transaction](#type-transaction)'s amount for Transactions which included additional recipients. The location of this receivable is that same as the one specified in the [AdditionalRecipient](#type-additionalrecipient).")
public class AdditionalRecipientReceivable {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="transaction_id")
    private String transactionId = null;
    @JsonProperty(value="transaction_location_id")
    private String transactionLocationId = null;
    @JsonProperty(value="amount_money")
    private Money amountMoney = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="refunds")
    private List<AdditionalRecipientReceivableRefund> refunds = new ArrayList<AdditionalRecipientReceivableRefund>();

    public AdditionalRecipientReceivable id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The additional recipient receivable's unique ID, issued by Square payments servers.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AdditionalRecipientReceivable transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the transaction that the additional recipient receivable was applied to.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public AdditionalRecipientReceivable transactionLocationId(String transactionLocationId) {
        this.transactionLocationId = transactionLocationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the location that created the receivable. This is the location ID on the associated transaction.")
    public String getTransactionLocationId() {
        return this.transactionLocationId;
    }

    public void setTransactionLocationId(String transactionLocationId) {
        this.transactionLocationId = transactionLocationId;
    }

    public AdditionalRecipientReceivable amountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of the receivable. This will always be non-negative.")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public void setAmountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
    }

    public AdditionalRecipientReceivable createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The time when the additional recipient receivable was created, in RFC 3339 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public AdditionalRecipientReceivable refunds(List<AdditionalRecipientReceivableRefund> refunds) {
        this.refunds = refunds;
        return this;
    }

    public AdditionalRecipientReceivable addRefundsItem(AdditionalRecipientReceivableRefund refundsItem) {
        this.refunds.add(refundsItem);
        return this;
    }

    @ApiModelProperty(value="Any refunds of the receivable that have been applied.")
    public List<AdditionalRecipientReceivableRefund> getRefunds() {
        return this.refunds;
    }

    public void setRefunds(List<AdditionalRecipientReceivableRefund> refunds) {
        this.refunds = refunds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalRecipientReceivable additionalRecipientReceivable = (AdditionalRecipientReceivable)o;
        return Objects.equals(this.id, additionalRecipientReceivable.id) && Objects.equals(this.transactionId, additionalRecipientReceivable.transactionId) && Objects.equals(this.transactionLocationId, additionalRecipientReceivable.transactionLocationId) && Objects.equals(this.amountMoney, additionalRecipientReceivable.amountMoney) && Objects.equals(this.createdAt, additionalRecipientReceivable.createdAt) && Objects.equals(this.refunds, additionalRecipientReceivable.refunds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.transactionId, this.transactionLocationId, this.amountMoney, this.createdAt, this.refunds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdditionalRecipientReceivable {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    transactionLocationId: ").append(this.toIndentedString(this.transactionLocationId)).append("\n");
        sb.append("    amountMoney: ").append(this.toIndentedString(this.amountMoney)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    refunds: ").append(this.toIndentedString(this.refunds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

