/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.InventoryChange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class BatchChangeInventoryRequest {
    @JsonProperty(value="idempotency_key")
    private String idempotencyKey = null;
    @JsonProperty(value="changes")
    private List<InventoryChange> changes = new ArrayList<InventoryChange>();
    @JsonProperty(value="ignore_unchanged_counts")
    private Boolean ignoreUnchangedCounts = null;

    public BatchChangeInventoryRequest idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @ApiModelProperty(value="A client-supplied, universally unique identifier (UUID) for the request.  See [Idempotency](/basics/api101/idempotency) in the [API Development 101](/basics/api101/overview) section for more information.")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public BatchChangeInventoryRequest changes(List<InventoryChange> changes) {
        this.changes = changes;
        return this;
    }

    public BatchChangeInventoryRequest addChangesItem(InventoryChange changesItem) {
        this.changes.add(changesItem);
        return this;
    }

    @ApiModelProperty(value="The set of physical counts and inventory adjustments to be made. Changes are applied based on the client-supplied timestamp and may be sent out of order. Max size is 100 changes.")
    public List<InventoryChange> getChanges() {
        return this.changes;
    }

    public void setChanges(List<InventoryChange> changes) {
        this.changes = changes;
    }

    public BatchChangeInventoryRequest ignoreUnchangedCounts(Boolean ignoreUnchangedCounts) {
        this.ignoreUnchangedCounts = ignoreUnchangedCounts;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the current physical count should be ignored if the quantity is unchanged since the last physical count. Default: `true`.")
    public Boolean getIgnoreUnchangedCounts() {
        return this.ignoreUnchangedCounts;
    }

    public void setIgnoreUnchangedCounts(Boolean ignoreUnchangedCounts) {
        this.ignoreUnchangedCounts = ignoreUnchangedCounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchChangeInventoryRequest batchChangeInventoryRequest = (BatchChangeInventoryRequest)o;
        return Objects.equals(this.idempotencyKey, batchChangeInventoryRequest.idempotencyKey) && Objects.equals(this.changes, batchChangeInventoryRequest.changes) && Objects.equals(this.ignoreUnchangedCounts, batchChangeInventoryRequest.ignoreUnchangedCounts);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.changes, this.ignoreUnchangedCounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchChangeInventoryRequest {\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    changes: ").append(this.toIndentedString(this.changes)).append("\n");
        sb.append("    ignoreUnchangedCounts: ").append(this.toIndentedString(this.ignoreUnchangedCounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

