/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A defined break template that sets an expectation for possible `Break`  instances on a `Shift`.")
public class BreakType {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="location_id")
    private String locationId = null;
    @JsonProperty(value="break_name")
    private String breakName = null;
    @JsonProperty(value="expected_duration")
    private String expectedDuration = null;
    @JsonProperty(value="is_paid")
    private Boolean isPaid = null;
    @JsonProperty(value="version")
    private Integer version = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="updated_at")
    private String updatedAt = null;

    public BreakType id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="UUID for this object.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BreakType locationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the business location this type of break applies to.")
    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public BreakType breakName(String breakName) {
        this.breakName = breakName;
        return this;
    }

    @ApiModelProperty(required=true, value="A human-readable name for this type of break. Will be displayed to employees in Square products.")
    public String getBreakName() {
        return this.breakName;
    }

    public void setBreakName(String breakName) {
        this.breakName = breakName;
    }

    public BreakType expectedDuration(String expectedDuration) {
        this.expectedDuration = expectedDuration;
        return this;
    }

    @ApiModelProperty(required=true, value="Format: RFC-3339 P[n]Y[n]M[n]DT[n]H[n]M[n]S. The expected length of this break. Precision below minutes is truncated.")
    public String getExpectedDuration() {
        return this.expectedDuration;
    }

    public void setExpectedDuration(String expectedDuration) {
        this.expectedDuration = expectedDuration;
    }

    public BreakType isPaid(Boolean isPaid) {
        this.isPaid = isPaid;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether this break counts towards time worked for compensation purposes.")
    public Boolean getIsPaid() {
        return this.isPaid;
    }

    public void setIsPaid(Boolean isPaid) {
        this.isPaid = isPaid;
    }

    public BreakType version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="Used for resolving concurrency issues; request will fail if version provided does not match server version at time of request. If a value is not provided, Square's servers execute a \"blind\" write; potentially  overwriting another writer's data.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public BreakType createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="A read-only timestamp in RFC 3339 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public BreakType updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="A read-only timestamp in RFC 3339 format.")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BreakType breakType = (BreakType)o;
        return Objects.equals(this.id, breakType.id) && Objects.equals(this.locationId, breakType.locationId) && Objects.equals(this.breakName, breakType.breakName) && Objects.equals(this.expectedDuration, breakType.expectedDuration) && Objects.equals(this.isPaid, breakType.isPaid) && Objects.equals(this.version, breakType.version) && Objects.equals(this.createdAt, breakType.createdAt) && Objects.equals(this.updatedAt, breakType.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.breakName, this.expectedDuration, this.isPaid, this.version, this.createdAt, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BreakType {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    breakName: ").append(this.toIndentedString(this.breakName)).append("\n");
        sb.append("    expectedDuration: ").append(this.toIndentedString(this.expectedDuration)).append("\n");
        sb.append("    isPaid: ").append(this.toIndentedString(this.isPaid)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

