/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An image file to use in Square catalogs. Can be associated with catalog items, item variations, and categories.")
public class CatalogImage {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="caption")
    private String caption = null;

    public CatalogImage name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The internal name of this image. Identifies this image in calls to the Connect APIs.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CatalogImage url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="The URL of this image. Generated by Square after an image is uploaded to the CreateCatalogImage endpoint.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public CatalogImage caption(String caption) {
        this.caption = caption;
        return this;
    }

    @ApiModelProperty(value="A caption that describes what is shown in the image. Displayed in the Square Online Store.")
    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogImage catalogImage = (CatalogImage)o;
        return Objects.equals(this.name, catalogImage.name) && Objects.equals(this.url, catalogImage.url) && Objects.equals(this.caption, catalogImage.caption);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.caption);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogImage {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    caption: ").append(this.toIndentedString(this.caption)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

