/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.CatalogItemModifierListInfo;
import com.squareup.connect.models.CatalogObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="An item (i.e., product family) in the Catalog object model.")
public class CatalogItem {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="abbreviation")
    private String abbreviation = null;
    @JsonProperty(value="label_color")
    private String labelColor = null;
    @JsonProperty(value="available_online")
    private Boolean availableOnline = null;
    @JsonProperty(value="available_for_pickup")
    private Boolean availableForPickup = null;
    @JsonProperty(value="available_electronically")
    private Boolean availableElectronically = null;
    @JsonProperty(value="category_id")
    private String categoryId = null;
    @JsonProperty(value="tax_ids")
    private List<String> taxIds = new ArrayList<String>();
    @JsonProperty(value="modifier_list_info")
    private List<CatalogItemModifierListInfo> modifierListInfo = new ArrayList<CatalogItemModifierListInfo>();
    @JsonProperty(value="image_url")
    private String imageUrl = null;
    @JsonProperty(value="variations")
    private List<CatalogObject> variations = new ArrayList<CatalogObject>();
    @JsonProperty(value="product_type")
    private ProductTypeEnum productType = null;
    @JsonProperty(value="skip_modifier_screen")
    private Boolean skipModifierScreen = null;

    public CatalogItem name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The item's name. Searchable. This field must not be empty. This field has max length of 512 Unicode code points.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CatalogItem description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The item's description. Searchable. This field has max length of 4096 Unicode code points.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CatalogItem abbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
        return this;
    }

    @ApiModelProperty(value="The text of the item's display label in the Square Point of Sale app. Only up to the first five characters of the string are used.  Searchable. This field has max length of 24 Unicode code points.")
    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public CatalogItem labelColor(String labelColor) {
        this.labelColor = labelColor;
        return this;
    }

    @ApiModelProperty(value="The color of the item's display label in the Square Point of Sale app. This must be a valid hex color code.")
    public String getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(String labelColor) {
        this.labelColor = labelColor;
    }

    public CatalogItem availableOnline(Boolean availableOnline) {
        this.availableOnline = availableOnline;
        return this;
    }

    @ApiModelProperty(value="If `true`, the item can be added to shipping orders from the merchant's online store.")
    public Boolean getAvailableOnline() {
        return this.availableOnline;
    }

    public void setAvailableOnline(Boolean availableOnline) {
        this.availableOnline = availableOnline;
    }

    public CatalogItem availableForPickup(Boolean availableForPickup) {
        this.availableForPickup = availableForPickup;
        return this;
    }

    @ApiModelProperty(value="If `true`, the item can be added to pickup orders from the merchant's online store.")
    public Boolean getAvailableForPickup() {
        return this.availableForPickup;
    }

    public void setAvailableForPickup(Boolean availableForPickup) {
        this.availableForPickup = availableForPickup;
    }

    public CatalogItem availableElectronically(Boolean availableElectronically) {
        this.availableElectronically = availableElectronically;
        return this;
    }

    @ApiModelProperty(value="If `true`, the item can be added to electronically fulfilled orders from the merchant's online store.")
    public Boolean getAvailableElectronically() {
        return this.availableElectronically;
    }

    public void setAvailableElectronically(Boolean availableElectronically) {
        this.availableElectronically = availableElectronically;
    }

    public CatalogItem categoryId(String categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @ApiModelProperty(value="The ID of the item's category, if any.")
    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public CatalogItem taxIds(List<String> taxIds) {
        this.taxIds = taxIds;
        return this;
    }

    public CatalogItem addTaxIdsItem(String taxIdsItem) {
        this.taxIds.add(taxIdsItem);
        return this;
    }

    @ApiModelProperty(value="A set of IDs indicating the [CatalogTax](#type-catalogtax)es that are enabled for this item. When updating an item, any taxes listed here will be added to the item. [CatalogTax](#type-catalogtax)es may also be added to or deleted from an item using `UpdateItemTaxes`.")
    public List<String> getTaxIds() {
        return this.taxIds;
    }

    public void setTaxIds(List<String> taxIds) {
        this.taxIds = taxIds;
    }

    public CatalogItem modifierListInfo(List<CatalogItemModifierListInfo> modifierListInfo) {
        this.modifierListInfo = modifierListInfo;
        return this;
    }

    public CatalogItem addModifierListInfoItem(CatalogItemModifierListInfo modifierListInfoItem) {
        this.modifierListInfo.add(modifierListInfoItem);
        return this;
    }

    @ApiModelProperty(value="A set of [CatalogItemModifierListInfo](#type-catalogitemmodifierlistinfo) objects representing the modifier lists that apply to this item, along with the overrides and min and max limits that are specific to this item. [CatalogModifierList](#type-catalogmodifierlist)s may also be added to or deleted from an item using `UpdateItemModifierLists`.")
    public List<CatalogItemModifierListInfo> getModifierListInfo() {
        return this.modifierListInfo;
    }

    public void setModifierListInfo(List<CatalogItemModifierListInfo> modifierListInfo) {
        this.modifierListInfo = modifierListInfo;
    }

    public CatalogItem imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    @ApiModelProperty(value="__Deprecated__. The URL of an image representing this item. Deprecated in favor of `image_id` in [`CatalogObject`](#type-catalogobject).")
    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public CatalogItem variations(List<CatalogObject> variations) {
        this.variations = variations;
        return this;
    }

    public CatalogItem addVariationsItem(CatalogObject variationsItem) {
        this.variations.add(variationsItem);
        return this;
    }

    @ApiModelProperty(value="A list of [CatalogObject](#type-catalogobject)s containing the [CatalogItemVariation](#type-catalogitemvariation)s for this item.")
    public List<CatalogObject> getVariations() {
        return this.variations;
    }

    public void setVariations(List<CatalogObject> variations) {
        this.variations = variations;
    }

    public CatalogItem productType(ProductTypeEnum productType) {
        this.productType = productType;
        return this;
    }

    @ApiModelProperty(value="The product type of the item. May not be changed once an item has been created.  Only items of product type `REGULAR` may be created by this API; items with other product types are read-only. See [CatalogItemProductType](#type-catalogitemproducttype) for possible values")
    public ProductTypeEnum getProductType() {
        return this.productType;
    }

    public void setProductType(ProductTypeEnum productType) {
        this.productType = productType;
    }

    public CatalogItem skipModifierScreen(Boolean skipModifierScreen) {
        this.skipModifierScreen = skipModifierScreen;
        return this;
    }

    @ApiModelProperty(value="If `false`, the Square Point of Sale app will present the [CatalogItem](#type-catalogitem)'s details screen immediately, allowing the merchant to choose [CatalogModifier](#type-catalogmodifier)s before adding the item to the cart.  This is the default behavior.  If `true`, the Square Point of Sale app will immediately add the item to the cart with the pre-selected modifiers, and merchants can edit modifiers by drilling down onto the item's details.  Third-party clients are encouraged to implement similar behaviors.")
    public Boolean getSkipModifierScreen() {
        return this.skipModifierScreen;
    }

    public void setSkipModifierScreen(Boolean skipModifierScreen) {
        this.skipModifierScreen = skipModifierScreen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogItem catalogItem = (CatalogItem)o;
        return Objects.equals(this.name, catalogItem.name) && Objects.equals(this.description, catalogItem.description) && Objects.equals(this.abbreviation, catalogItem.abbreviation) && Objects.equals(this.labelColor, catalogItem.labelColor) && Objects.equals(this.availableOnline, catalogItem.availableOnline) && Objects.equals(this.availableForPickup, catalogItem.availableForPickup) && Objects.equals(this.availableElectronically, catalogItem.availableElectronically) && Objects.equals(this.categoryId, catalogItem.categoryId) && Objects.equals(this.taxIds, catalogItem.taxIds) && Objects.equals(this.modifierListInfo, catalogItem.modifierListInfo) && Objects.equals(this.imageUrl, catalogItem.imageUrl) && Objects.equals(this.variations, catalogItem.variations) && Objects.equals((Object)this.productType, (Object)catalogItem.productType) && Objects.equals(this.skipModifierScreen, catalogItem.skipModifierScreen);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.abbreviation, this.labelColor, this.availableOnline, this.availableForPickup, this.availableElectronically, this.categoryId, this.taxIds, this.modifierListInfo, this.imageUrl, this.variations, this.productType, this.skipModifierScreen});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogItem {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    abbreviation: ").append(this.toIndentedString(this.abbreviation)).append("\n");
        sb.append("    labelColor: ").append(this.toIndentedString(this.labelColor)).append("\n");
        sb.append("    availableOnline: ").append(this.toIndentedString(this.availableOnline)).append("\n");
        sb.append("    availableForPickup: ").append(this.toIndentedString(this.availableForPickup)).append("\n");
        sb.append("    availableElectronically: ").append(this.toIndentedString(this.availableElectronically)).append("\n");
        sb.append("    categoryId: ").append(this.toIndentedString(this.categoryId)).append("\n");
        sb.append("    taxIds: ").append(this.toIndentedString(this.taxIds)).append("\n");
        sb.append("    modifierListInfo: ").append(this.toIndentedString(this.modifierListInfo)).append("\n");
        sb.append("    imageUrl: ").append(this.toIndentedString(this.imageUrl)).append("\n");
        sb.append("    variations: ").append(this.toIndentedString(this.variations)).append("\n");
        sb.append("    productType: ").append(this.toIndentedString((Object)this.productType)).append("\n");
        sb.append("    skipModifierScreen: ").append(this.toIndentedString(this.skipModifierScreen)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProductTypeEnum {
        REGULAR("REGULAR"),
        GIFT_CARD("GIFT_CARD"),
        APPOINTMENTS_SERVICE("APPOINTMENTS_SERVICE"),
        RETAIL_ITEM("RETAIL_ITEM"),
        RESTAURANT_ITEM("RESTAURANT_ITEM");

        private String value;

        private ProductTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProductTypeEnum fromValue(String text) {
            for (ProductTypeEnum b : ProductTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

