/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.CatalogObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A modifier list in the Catalog object model. A [CatalogModifierList](#type-catalogmodifierlist) contains [Modifier](#type-catalogmodifier)s that can be applied to a [CatalogItem](#type-catalogitem) at the time of sale.  For example, a modifier list \"Condiments\" that would apply to a \"Hot Dog\" [CatalogItem](#type-catalogitem) might contain [CatalogModifier](#type-catalogmodifier)s \"Ketchup\", \"Mustard\", and \"Relish\". The `selection_type` field specifies whether or not multiple selections from the modifier list are allowed.")
public class CatalogModifierList {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="selection_type")
    private SelectionTypeEnum selectionType = null;
    @JsonProperty(value="modifiers")
    private List<CatalogObject> modifiers = new ArrayList<CatalogObject>();

    public CatalogModifierList name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The [CatalogModifierList](#type-catalogmodifierlist)'s name. Searchable. This field has max length of 255 Unicode code points.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CatalogModifierList selectionType(SelectionTypeEnum selectionType) {
        this.selectionType = selectionType;
        return this;
    }

    @ApiModelProperty(value="Indicates whether multiple options from the [CatalogModifierList](#type-catalogmodifierlist) can be applied to a single [CatalogItem](#type-catalogitem). See [CatalogModifierListSelectionType](#type-catalogmodifierlistselectiontype) for possible values")
    public SelectionTypeEnum getSelectionType() {
        return this.selectionType;
    }

    public void setSelectionType(SelectionTypeEnum selectionType) {
        this.selectionType = selectionType;
    }

    public CatalogModifierList modifiers(List<CatalogObject> modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public CatalogModifierList addModifiersItem(CatalogObject modifiersItem) {
        this.modifiers.add(modifiersItem);
        return this;
    }

    @ApiModelProperty(value="The options included in the [CatalogModifierList](#type-catalogmodifierlist). You must include at least one [CatalogModifier](#type-catalogmodifier). Each [CatalogObject](#type-catalogobject) must have type `MODIFIER` and contain [CatalogModifier](#type-catalogmodifier) data.")
    public List<CatalogObject> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(List<CatalogObject> modifiers) {
        this.modifiers = modifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogModifierList catalogModifierList = (CatalogModifierList)o;
        return Objects.equals(this.name, catalogModifierList.name) && Objects.equals((Object)this.selectionType, (Object)catalogModifierList.selectionType) && Objects.equals(this.modifiers, catalogModifierList.modifiers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.selectionType, this.modifiers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogModifierList {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    selectionType: ").append(this.toIndentedString((Object)this.selectionType)).append("\n");
        sb.append("    modifiers: ").append(this.toIndentedString(this.modifiers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SelectionTypeEnum {
        SINGLE("SINGLE"),
        MULTIPLE("MULTIPLE");

        private String value;

        private SelectionTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SelectionTypeEnum fromValue(String text) {
            for (SelectionTypeEnum b : SelectionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

