/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A tax in the Catalog object model.")
public class CatalogTax {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="calculation_phase")
    private CalculationPhaseEnum calculationPhase = null;
    @JsonProperty(value="inclusion_type")
    private InclusionTypeEnum inclusionType = null;
    @JsonProperty(value="percentage")
    private String percentage = null;
    @JsonProperty(value="applies_to_custom_amounts")
    private Boolean appliesToCustomAmounts = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;

    public CatalogTax name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The tax's name. Searchable. This field has max length of 255 Unicode code points.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CatalogTax calculationPhase(CalculationPhaseEnum calculationPhase) {
        this.calculationPhase = calculationPhase;
        return this;
    }

    @ApiModelProperty(value="Whether the tax is calculated based on a payment's subtotal or total. See [TaxCalculationPhase](#type-taxcalculationphase) for possible values")
    public CalculationPhaseEnum getCalculationPhase() {
        return this.calculationPhase;
    }

    public void setCalculationPhase(CalculationPhaseEnum calculationPhase) {
        this.calculationPhase = calculationPhase;
    }

    public CatalogTax inclusionType(InclusionTypeEnum inclusionType) {
        this.inclusionType = inclusionType;
        return this;
    }

    @ApiModelProperty(value="Whether the tax is `ADDITIVE` or `INCLUSIVE`. See [TaxInclusionType](#type-taxinclusiontype) for possible values")
    public InclusionTypeEnum getInclusionType() {
        return this.inclusionType;
    }

    public void setInclusionType(InclusionTypeEnum inclusionType) {
        this.inclusionType = inclusionType;
    }

    public CatalogTax percentage(String percentage) {
        this.percentage = percentage;
        return this;
    }

    @ApiModelProperty(value="The percentage of the tax in decimal form, using a `'.'` as the decimal separator and without a `'%'` sign. A value of `7.5` corresponds to 7.5%.")
    public String getPercentage() {
        return this.percentage;
    }

    public void setPercentage(String percentage) {
        this.percentage = percentage;
    }

    public CatalogTax appliesToCustomAmounts(Boolean appliesToCustomAmounts) {
        this.appliesToCustomAmounts = appliesToCustomAmounts;
        return this;
    }

    @ApiModelProperty(value="If `true`, the fee applies to custom amounts entered into the Square Point of Sale app that are not associated with a particular [CatalogItem](#type-catalogitem).")
    public Boolean getAppliesToCustomAmounts() {
        return this.appliesToCustomAmounts;
    }

    public void setAppliesToCustomAmounts(Boolean appliesToCustomAmounts) {
        this.appliesToCustomAmounts = appliesToCustomAmounts;
    }

    public CatalogTax enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="If `true`, the tax will be shown as enabled in the Square Point of Sale app.")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogTax catalogTax = (CatalogTax)o;
        return Objects.equals(this.name, catalogTax.name) && Objects.equals((Object)this.calculationPhase, (Object)catalogTax.calculationPhase) && Objects.equals((Object)this.inclusionType, (Object)catalogTax.inclusionType) && Objects.equals(this.percentage, catalogTax.percentage) && Objects.equals(this.appliesToCustomAmounts, catalogTax.appliesToCustomAmounts) && Objects.equals(this.enabled, catalogTax.enabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.calculationPhase, this.inclusionType, this.percentage, this.appliesToCustomAmounts, this.enabled});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogTax {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    calculationPhase: ").append(this.toIndentedString((Object)this.calculationPhase)).append("\n");
        sb.append("    inclusionType: ").append(this.toIndentedString((Object)this.inclusionType)).append("\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    appliesToCustomAmounts: ").append(this.toIndentedString(this.appliesToCustomAmounts)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InclusionTypeEnum {
        ADDITIVE("ADDITIVE"),
        INCLUSIVE("INCLUSIVE");

        private String value;

        private InclusionTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InclusionTypeEnum fromValue(String text) {
            for (InclusionTypeEnum b : InclusionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum CalculationPhaseEnum {
        SUBTOTAL_PHASE("TAX_SUBTOTAL_PHASE"),
        TOTAL_PHASE("TAX_TOTAL_PHASE");

        private String value;

        private CalculationPhaseEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CalculationPhaseEnum fromValue(String text) {
            for (CalculationPhaseEnum b : CalculationPhaseEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

