/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.AdditionalRecipient;
import com.squareup.connect.models.Address;
import com.squareup.connect.models.Order;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Square Checkout lets merchants accept online payments for supported payment types using a checkout workflow hosted on squareup.com.")
public class Checkout {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="checkout_page_url")
    private String checkoutPageUrl = null;
    @JsonProperty(value="ask_for_shipping_address")
    private Boolean askForShippingAddress = null;
    @JsonProperty(value="merchant_support_email")
    private String merchantSupportEmail = null;
    @JsonProperty(value="pre_populate_buyer_email")
    private String prePopulateBuyerEmail = null;
    @JsonProperty(value="pre_populate_shipping_address")
    private Address prePopulateShippingAddress = null;
    @JsonProperty(value="redirect_url")
    private String redirectUrl = null;
    @JsonProperty(value="order")
    private Order order = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="additional_recipients")
    private List<AdditionalRecipient> additionalRecipients = new ArrayList<AdditionalRecipient>();

    public Checkout id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="ID generated by Square Checkout when a new checkout is requested.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Checkout checkoutPageUrl(String checkoutPageUrl) {
        this.checkoutPageUrl = checkoutPageUrl;
        return this;
    }

    @ApiModelProperty(value="The URL that the buyer's browser should be redirected to after the checkout is completed.")
    public String getCheckoutPageUrl() {
        return this.checkoutPageUrl;
    }

    public void setCheckoutPageUrl(String checkoutPageUrl) {
        this.checkoutPageUrl = checkoutPageUrl;
    }

    public Checkout askForShippingAddress(Boolean askForShippingAddress) {
        this.askForShippingAddress = askForShippingAddress;
        return this;
    }

    @ApiModelProperty(value="If `true`, Square Checkout will collect shipping information on your behalf and store that information with the transaction information in your Square Dashboard.  Default: `false`.")
    public Boolean getAskForShippingAddress() {
        return this.askForShippingAddress;
    }

    public void setAskForShippingAddress(Boolean askForShippingAddress) {
        this.askForShippingAddress = askForShippingAddress;
    }

    public Checkout merchantSupportEmail(String merchantSupportEmail) {
        this.merchantSupportEmail = merchantSupportEmail;
        return this;
    }

    @ApiModelProperty(value="The email address to display on the Square Checkout confirmation page and confirmation email that the buyer can use to contact the merchant.  If this value is not set, the confirmation page and email will display the primary email address associated with the merchant's Square account.  Default: none; only exists if explicitly set.")
    public String getMerchantSupportEmail() {
        return this.merchantSupportEmail;
    }

    public void setMerchantSupportEmail(String merchantSupportEmail) {
        this.merchantSupportEmail = merchantSupportEmail;
    }

    public Checkout prePopulateBuyerEmail(String prePopulateBuyerEmail) {
        this.prePopulateBuyerEmail = prePopulateBuyerEmail;
        return this;
    }

    @ApiModelProperty(value="If provided, the buyer's email is pre-populated on the checkout page as an editable text field.  Default: none; only exists if explicitly set.")
    public String getPrePopulateBuyerEmail() {
        return this.prePopulateBuyerEmail;
    }

    public void setPrePopulateBuyerEmail(String prePopulateBuyerEmail) {
        this.prePopulateBuyerEmail = prePopulateBuyerEmail;
    }

    public Checkout prePopulateShippingAddress(Address prePopulateShippingAddress) {
        this.prePopulateShippingAddress = prePopulateShippingAddress;
        return this;
    }

    @ApiModelProperty(value="If provided, the buyer's shipping info is pre-populated on the checkout page as editable text fields.  Default: none; only exists if explicitly set.")
    public Address getPrePopulateShippingAddress() {
        return this.prePopulateShippingAddress;
    }

    public void setPrePopulateShippingAddress(Address prePopulateShippingAddress) {
        this.prePopulateShippingAddress = prePopulateShippingAddress;
    }

    public Checkout redirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @ApiModelProperty(value="The URL to redirect to after checkout is completed with `checkoutId`, Square's `orderId`, `transactionId`, and `referenceId` appended as URL parameters. For example, if the provided redirect_url is `http://www.example.com/order-complete`, a successful transaction redirects the customer to:  `http://www.example.com/order-complete?checkoutId=xxxxxx&orderId=xxxxxx&referenceId=xxxxxx&transactionId=xxxxxx`  If you do not provide a redirect URL, Square Checkout will display an order confirmation page on your behalf; however Square strongly recommends that you provide a redirect URL so you can verify the transaction results and finalize the order through your existing/normal confirmation workflow.")
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public Checkout order(Order order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(value="Order to be checked out.")
    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public Checkout createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The time when the checkout was created, in RFC 3339 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Checkout additionalRecipients(List<AdditionalRecipient> additionalRecipients) {
        this.additionalRecipients = additionalRecipients;
        return this;
    }

    public Checkout addAdditionalRecipientsItem(AdditionalRecipient additionalRecipientsItem) {
        this.additionalRecipients.add(additionalRecipientsItem);
        return this;
    }

    @ApiModelProperty(value="Additional recipients (other than the merchant) receiving a portion of this checkout. For example, fees assessed on the purchase by a third party integration.")
    public List<AdditionalRecipient> getAdditionalRecipients() {
        return this.additionalRecipients;
    }

    public void setAdditionalRecipients(List<AdditionalRecipient> additionalRecipients) {
        this.additionalRecipients = additionalRecipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checkout checkout = (Checkout)o;
        return Objects.equals(this.id, checkout.id) && Objects.equals(this.checkoutPageUrl, checkout.checkoutPageUrl) && Objects.equals(this.askForShippingAddress, checkout.askForShippingAddress) && Objects.equals(this.merchantSupportEmail, checkout.merchantSupportEmail) && Objects.equals(this.prePopulateBuyerEmail, checkout.prePopulateBuyerEmail) && Objects.equals(this.prePopulateShippingAddress, checkout.prePopulateShippingAddress) && Objects.equals(this.redirectUrl, checkout.redirectUrl) && Objects.equals(this.order, checkout.order) && Objects.equals(this.createdAt, checkout.createdAt) && Objects.equals(this.additionalRecipients, checkout.additionalRecipients);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.checkoutPageUrl, this.askForShippingAddress, this.merchantSupportEmail, this.prePopulateBuyerEmail, this.prePopulateShippingAddress, this.redirectUrl, this.order, this.createdAt, this.additionalRecipients);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Checkout {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    checkoutPageUrl: ").append(this.toIndentedString(this.checkoutPageUrl)).append("\n");
        sb.append("    askForShippingAddress: ").append(this.toIndentedString(this.askForShippingAddress)).append("\n");
        sb.append("    merchantSupportEmail: ").append(this.toIndentedString(this.merchantSupportEmail)).append("\n");
        sb.append("    prePopulateBuyerEmail: ").append(this.toIndentedString(this.prePopulateBuyerEmail)).append("\n");
        sb.append("    prePopulateShippingAddress: ").append(this.toIndentedString(this.prePopulateShippingAddress)).append("\n");
        sb.append("    redirectUrl: ").append(this.toIndentedString(this.redirectUrl)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    additionalRecipients: ").append(this.toIndentedString(this.additionalRecipients)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

