/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Address;
import com.squareup.connect.models.ChargeRequestAdditionalRecipient;
import com.squareup.connect.models.CreateOrderRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines the parameters that can be included in the body of a request to the [CreateCheckout](#endpoint-createcheckout) endpoint.")
public class CreateCheckoutRequest {
    @JsonProperty(value="idempotency_key")
    private String idempotencyKey = null;
    @JsonProperty(value="order")
    private CreateOrderRequest order = null;
    @JsonProperty(value="ask_for_shipping_address")
    private Boolean askForShippingAddress = null;
    @JsonProperty(value="merchant_support_email")
    private String merchantSupportEmail = null;
    @JsonProperty(value="pre_populate_buyer_email")
    private String prePopulateBuyerEmail = null;
    @JsonProperty(value="pre_populate_shipping_address")
    private Address prePopulateShippingAddress = null;
    @JsonProperty(value="redirect_url")
    private String redirectUrl = null;
    @JsonProperty(value="additional_recipients")
    private List<ChargeRequestAdditionalRecipient> additionalRecipients = new ArrayList<ChargeRequestAdditionalRecipient>();
    @JsonProperty(value="note")
    private String note = null;

    public CreateCheckoutRequest idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique string that identifies this checkout among others you've created. It can be any valid string but must be unique for every order sent to Square Checkout for a given location ID.  The idempotency key is used to avoid processing the same order more than once. If you're unsure whether a particular checkout was created successfully, you can reattempt it with the same idempotency key and all the same other parameters without worrying about creating duplicates.  We recommend using a random number/string generator native to the language you are working in to generate strings for your idempotency keys.  See [Idempotency](/basics/api101/idempotency) for more information.")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public CreateCheckoutRequest order(CreateOrderRequest order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(required=true, value="The order including line items to be checked out.")
    public CreateOrderRequest getOrder() {
        return this.order;
    }

    public void setOrder(CreateOrderRequest order) {
        this.order = order;
    }

    public CreateCheckoutRequest askForShippingAddress(Boolean askForShippingAddress) {
        this.askForShippingAddress = askForShippingAddress;
        return this;
    }

    @ApiModelProperty(value="If `true`, Square Checkout will collect shipping information on your behalf and store that information with the transaction information in your Square Dashboard.  Default: `false`.")
    public Boolean getAskForShippingAddress() {
        return this.askForShippingAddress;
    }

    public void setAskForShippingAddress(Boolean askForShippingAddress) {
        this.askForShippingAddress = askForShippingAddress;
    }

    public CreateCheckoutRequest merchantSupportEmail(String merchantSupportEmail) {
        this.merchantSupportEmail = merchantSupportEmail;
        return this;
    }

    @ApiModelProperty(value="The email address to display on the Square Checkout confirmation page and confirmation email that the buyer can use to contact the merchant.  If this value is not set, the confirmation page and email will display the primary email address associated with the merchant's Square account.  Default: none; only exists if explicitly set.")
    public String getMerchantSupportEmail() {
        return this.merchantSupportEmail;
    }

    public void setMerchantSupportEmail(String merchantSupportEmail) {
        this.merchantSupportEmail = merchantSupportEmail;
    }

    public CreateCheckoutRequest prePopulateBuyerEmail(String prePopulateBuyerEmail) {
        this.prePopulateBuyerEmail = prePopulateBuyerEmail;
        return this;
    }

    @ApiModelProperty(value="If provided, the buyer's email is pre-populated on the checkout page as an editable text field.  Default: none; only exists if explicitly set.")
    public String getPrePopulateBuyerEmail() {
        return this.prePopulateBuyerEmail;
    }

    public void setPrePopulateBuyerEmail(String prePopulateBuyerEmail) {
        this.prePopulateBuyerEmail = prePopulateBuyerEmail;
    }

    public CreateCheckoutRequest prePopulateShippingAddress(Address prePopulateShippingAddress) {
        this.prePopulateShippingAddress = prePopulateShippingAddress;
        return this;
    }

    @ApiModelProperty(value="If provided, the buyer's shipping info is pre-populated on the checkout page as editable text fields.  Default: none; only exists if explicitly set.")
    public Address getPrePopulateShippingAddress() {
        return this.prePopulateShippingAddress;
    }

    public void setPrePopulateShippingAddress(Address prePopulateShippingAddress) {
        this.prePopulateShippingAddress = prePopulateShippingAddress;
    }

    public CreateCheckoutRequest redirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @ApiModelProperty(value="The URL to redirect to after checkout is completed with `checkoutId`, Square's `orderId`, `transactionId`, and `referenceId` appended as URL parameters. For example, if the provided redirect_url is `http://www.example.com/order-complete`, a successful transaction redirects the customer to:  `http://www.example.com/order-complete?checkoutId=xxxxxx&orderId=xxxxxx&referenceId=xxxxxx&transactionId=xxxxxx`  If you do not provide a redirect URL, Square Checkout will display an order confirmation page on your behalf; however Square strongly recommends that you provide a redirect URL so you can verify the transaction results and finalize the order through your existing/normal confirmation workflow.  Default: none; only exists if explicitly set.")
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public CreateCheckoutRequest additionalRecipients(List<ChargeRequestAdditionalRecipient> additionalRecipients) {
        this.additionalRecipients = additionalRecipients;
        return this;
    }

    public CreateCheckoutRequest addAdditionalRecipientsItem(ChargeRequestAdditionalRecipient additionalRecipientsItem) {
        this.additionalRecipients.add(additionalRecipientsItem);
        return this;
    }

    @ApiModelProperty(value="The basic primitive of multi-party transaction. The value is optional. The transaction facilitated by you can be split from here.  If you provide this value, the `amount_money` value in your additional_recipients must not be more than 90% of the `total_money` calculated by Square for your order. The `location_id` must be the valid location of the app owner merchant.  This field requires `PAYMENTS_WRITE_ADDITIONAL_RECIPIENTS` OAuth permission.  This field is currently not supported in sandbox.")
    public List<ChargeRequestAdditionalRecipient> getAdditionalRecipients() {
        return this.additionalRecipients;
    }

    public void setAdditionalRecipients(List<ChargeRequestAdditionalRecipient> additionalRecipients) {
        this.additionalRecipients = additionalRecipients;
    }

    public CreateCheckoutRequest note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(value="An optional note to associate with the checkout object.  This value cannot exceed 60 characters.")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCheckoutRequest createCheckoutRequest = (CreateCheckoutRequest)o;
        return Objects.equals(this.idempotencyKey, createCheckoutRequest.idempotencyKey) && Objects.equals(this.order, createCheckoutRequest.order) && Objects.equals(this.askForShippingAddress, createCheckoutRequest.askForShippingAddress) && Objects.equals(this.merchantSupportEmail, createCheckoutRequest.merchantSupportEmail) && Objects.equals(this.prePopulateBuyerEmail, createCheckoutRequest.prePopulateBuyerEmail) && Objects.equals(this.prePopulateShippingAddress, createCheckoutRequest.prePopulateShippingAddress) && Objects.equals(this.redirectUrl, createCheckoutRequest.redirectUrl) && Objects.equals(this.additionalRecipients, createCheckoutRequest.additionalRecipients) && Objects.equals(this.note, createCheckoutRequest.note);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.order, this.askForShippingAddress, this.merchantSupportEmail, this.prePopulateBuyerEmail, this.prePopulateShippingAddress, this.redirectUrl, this.additionalRecipients, this.note);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCheckoutRequest {\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    askForShippingAddress: ").append(this.toIndentedString(this.askForShippingAddress)).append("\n");
        sb.append("    merchantSupportEmail: ").append(this.toIndentedString(this.merchantSupportEmail)).append("\n");
        sb.append("    prePopulateBuyerEmail: ").append(this.toIndentedString(this.prePopulateBuyerEmail)).append("\n");
        sb.append("    prePopulateShippingAddress: ").append(this.toIndentedString(this.prePopulateShippingAddress)).append("\n");
        sb.append("    redirectUrl: ").append(this.toIndentedString(this.redirectUrl)).append("\n");
        sb.append("    additionalRecipients: ").append(this.toIndentedString(this.additionalRecipients)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

