/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Checkout;
import com.squareup.connect.models.Error;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines the fields that are included in the response body of a request to the [CreateCheckout](#endpoint-createcheckout) endpoint.")
public class CreateCheckoutResponse {
    @JsonProperty(value="checkout")
    private Checkout checkout = null;
    @JsonProperty(value="errors")
    private List<Error> errors = new ArrayList<Error>();

    public CreateCheckoutResponse checkout(Checkout checkout) {
        this.checkout = checkout;
        return this;
    }

    @ApiModelProperty(value="The newly created checkout. If the same request was made with the same idempotency_key, this will be the checkout created with the idempotency_key.")
    public Checkout getCheckout() {
        return this.checkout;
    }

    public void setCheckout(Checkout checkout) {
        this.checkout = checkout;
    }

    public CreateCheckoutResponse errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public CreateCheckoutResponse addErrorsItem(Error errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="Any errors that occurred during the request.")
    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCheckoutResponse createCheckoutResponse = (CreateCheckoutResponse)o;
        return Objects.equals(this.checkout, createCheckoutResponse.checkout) && Objects.equals(this.errors, createCheckoutResponse.errors);
    }

    public int hashCode() {
        return Objects.hash(this.checkout, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCheckoutResponse {\n");
        sb.append("    checkout: ").append(this.toIndentedString(this.checkout)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

