/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Address;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Defines the body parameters that can be provided in a request to the [CreateCustomer](#endpoint-createcustomer) endpoint.")
public class CreateCustomerRequest {
    @JsonProperty(value="idempotency_key")
    private String idempotencyKey = null;
    @JsonProperty(value="given_name")
    private String givenName = null;
    @JsonProperty(value="family_name")
    private String familyName = null;
    @JsonProperty(value="company_name")
    private String companyName = null;
    @JsonProperty(value="nickname")
    private String nickname = null;
    @JsonProperty(value="email_address")
    private String emailAddress = null;
    @JsonProperty(value="address")
    private Address address = null;
    @JsonProperty(value="phone_number")
    private String phoneNumber = null;
    @JsonProperty(value="reference_id")
    private String referenceId = null;
    @JsonProperty(value="note")
    private String note = null;
    @JsonProperty(value="birthday")
    private String birthday = null;

    public CreateCustomerRequest idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @ApiModelProperty(value="The idempotency key for the request. See the [Idempotency](/basics/api101/idempotency) guide for more information.")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public CreateCustomerRequest givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @ApiModelProperty(value="The customer's given (i.e., first) name.")
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public CreateCustomerRequest familyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    @ApiModelProperty(value="The customer's family (i.e., last) name.")
    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public CreateCustomerRequest companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @ApiModelProperty(value="The name of the customer's company.")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public CreateCustomerRequest nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @ApiModelProperty(value="A nickname for the customer.")
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public CreateCustomerRequest emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @ApiModelProperty(value="The customer's email address.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public CreateCustomerRequest address(Address address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="The customer's physical address.")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public CreateCustomerRequest phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="The customer's phone number.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public CreateCustomerRequest referenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    @ApiModelProperty(value="An optional second ID you can set to associate the customer with an entity in another system.")
    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public CreateCustomerRequest note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(value="An optional note to associate with the customer.")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public CreateCustomerRequest birthday(String birthday) {
        this.birthday = birthday;
        return this;
    }

    @ApiModelProperty(value="The customer birthday in RFC-3339 format. Year is optional, timezone and times are not allowed. Example: `0000-09-01T00:00:00-00:00` for a birthday on September 1st. `1998-09-01T00:00:00-00:00` for a birthday on September 1st 1998.")
    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCustomerRequest createCustomerRequest = (CreateCustomerRequest)o;
        return Objects.equals(this.idempotencyKey, createCustomerRequest.idempotencyKey) && Objects.equals(this.givenName, createCustomerRequest.givenName) && Objects.equals(this.familyName, createCustomerRequest.familyName) && Objects.equals(this.companyName, createCustomerRequest.companyName) && Objects.equals(this.nickname, createCustomerRequest.nickname) && Objects.equals(this.emailAddress, createCustomerRequest.emailAddress) && Objects.equals(this.address, createCustomerRequest.address) && Objects.equals(this.phoneNumber, createCustomerRequest.phoneNumber) && Objects.equals(this.referenceId, createCustomerRequest.referenceId) && Objects.equals(this.note, createCustomerRequest.note) && Objects.equals(this.birthday, createCustomerRequest.birthday);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.givenName, this.familyName, this.companyName, this.nickname, this.emailAddress, this.address, this.phoneNumber, this.referenceId, this.note, this.birthday);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCustomerRequest {\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    referenceId: ").append(this.toIndentedString(this.referenceId)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    birthday: ").append(this.toIndentedString(this.birthday)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

