/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Error;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Defines the fields that are included in the response body of a request to the [CreateMobileAuthorizationCode](#endpoint-createmobileauthorizationcode) endpoint.")
public class CreateMobileAuthorizationCodeResponse {
    @JsonProperty(value="authorization_code")
    private String authorizationCode = null;
    @JsonProperty(value="expires_at")
    private String expiresAt = null;
    @JsonProperty(value="error")
    private Error error = null;

    public CreateMobileAuthorizationCodeResponse authorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
        return this;
    }

    @ApiModelProperty(value="Generated authorization code that connects a mobile application instance to a Square account.")
    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public CreateMobileAuthorizationCodeResponse expiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @ApiModelProperty(value="The timestamp when `authorization_code` expires in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, e.g., \"2016-09-04T23:59:33.123Z\".")
    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public CreateMobileAuthorizationCodeResponse error(Error error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(value="An error object that provides details about how creation of authorization code failed.")
    public Error getError() {
        return this.error;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMobileAuthorizationCodeResponse createMobileAuthorizationCodeResponse = (CreateMobileAuthorizationCodeResponse)o;
        return Objects.equals(this.authorizationCode, createMobileAuthorizationCodeResponse.authorizationCode) && Objects.equals(this.expiresAt, createMobileAuthorizationCodeResponse.expiresAt) && Objects.equals(this.error, createMobileAuthorizationCodeResponse.error);
    }

    public int hashCode() {
        return Objects.hash(this.authorizationCode, this.expiresAt, this.error);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMobileAuthorizationCodeResponse {\n");
        sb.append("    authorizationCode: ").append(this.toIndentedString(this.authorizationCode)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

