/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.CreateOrderRequestDiscount;
import com.squareup.connect.models.CreateOrderRequestLineItem;
import com.squareup.connect.models.CreateOrderRequestTax;
import com.squareup.connect.models.Order;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class CreateOrderRequest {
    @JsonProperty(value="order")
    private Order order = null;
    @JsonProperty(value="idempotency_key")
    private String idempotencyKey = null;
    @JsonProperty(value="reference_id")
    private String referenceId = null;
    @JsonProperty(value="line_items")
    private List<CreateOrderRequestLineItem> lineItems = new ArrayList<CreateOrderRequestLineItem>();
    @JsonProperty(value="taxes")
    private List<CreateOrderRequestTax> taxes = new ArrayList<CreateOrderRequestTax>();
    @JsonProperty(value="discounts")
    private List<CreateOrderRequestDiscount> discounts = new ArrayList<CreateOrderRequestDiscount>();

    public CreateOrderRequest order(Order order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(value="The order to create. If this field is set, then the only other top-level field that can be set is the idempotency_key.")
    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public CreateOrderRequest idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @ApiModelProperty(value="A value you specify that uniquely identifies this order among orders you've created.  If you're unsure whether a particular order was created successfully, you can reattempt it with the same idempotency key without worrying about creating duplicate orders.  See [Idempotency](/basics/api101/idempotency) for more information.")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public CreateOrderRequest referenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    @ApiModelProperty(value="__Deprecated__: Please set the reference_id on the nested [order](#type-order) field instead.  An optional ID you can associate with the order for your own purposes (such as to associate the order with an entity ID in your own database).  This value cannot exceed 40 characters.")
    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public CreateOrderRequest lineItems(List<CreateOrderRequestLineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public CreateOrderRequest addLineItemsItem(CreateOrderRequestLineItem lineItemsItem) {
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="__Deprecated__: Please set the line_items on the nested [order](#type-order) field instead.  The line items to associate with this order.  Each line item represents a different product to include in a purchase.")
    public List<CreateOrderRequestLineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<CreateOrderRequestLineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public CreateOrderRequest taxes(List<CreateOrderRequestTax> taxes) {
        this.taxes = taxes;
        return this;
    }

    public CreateOrderRequest addTaxesItem(CreateOrderRequestTax taxesItem) {
        this.taxes.add(taxesItem);
        return this;
    }

    @ApiModelProperty(value="__Deprecated__: Please set the taxes on the nested [order](#type-order) field instead.  The taxes to include on the order.")
    public List<CreateOrderRequestTax> getTaxes() {
        return this.taxes;
    }

    public void setTaxes(List<CreateOrderRequestTax> taxes) {
        this.taxes = taxes;
    }

    public CreateOrderRequest discounts(List<CreateOrderRequestDiscount> discounts) {
        this.discounts = discounts;
        return this;
    }

    public CreateOrderRequest addDiscountsItem(CreateOrderRequestDiscount discountsItem) {
        this.discounts.add(discountsItem);
        return this;
    }

    @ApiModelProperty(value="__Deprecated__: Please set the discounts on the nested [order](#type-order) field instead.  The discounts to include on the order.")
    public List<CreateOrderRequestDiscount> getDiscounts() {
        return this.discounts;
    }

    public void setDiscounts(List<CreateOrderRequestDiscount> discounts) {
        this.discounts = discounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrderRequest createOrderRequest = (CreateOrderRequest)o;
        return Objects.equals(this.order, createOrderRequest.order) && Objects.equals(this.idempotencyKey, createOrderRequest.idempotencyKey) && Objects.equals(this.referenceId, createOrderRequest.referenceId) && Objects.equals(this.lineItems, createOrderRequest.lineItems) && Objects.equals(this.taxes, createOrderRequest.taxes) && Objects.equals(this.discounts, createOrderRequest.discounts);
    }

    public int hashCode() {
        return Objects.hash(this.order, this.idempotencyKey, this.referenceId, this.lineItems, this.taxes, this.discounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateOrderRequest {\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    referenceId: ").append(this.toIndentedString(this.referenceId)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    taxes: ").append(this.toIndentedString(this.taxes)).append("\n");
        sb.append("    discounts: ").append(this.toIndentedString(this.discounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

