/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Address;
import com.squareup.connect.models.Card;
import com.squareup.connect.models.CustomerGroupInfo;
import com.squareup.connect.models.CustomerPreferences;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents one of a business's customers, which can have one or more cards on file associated with it.")
public class Customer {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="updated_at")
    private String updatedAt = null;
    @JsonProperty(value="cards")
    private List<Card> cards = new ArrayList<Card>();
    @JsonProperty(value="given_name")
    private String givenName = null;
    @JsonProperty(value="family_name")
    private String familyName = null;
    @JsonProperty(value="nickname")
    private String nickname = null;
    @JsonProperty(value="company_name")
    private String companyName = null;
    @JsonProperty(value="email_address")
    private String emailAddress = null;
    @JsonProperty(value="address")
    private Address address = null;
    @JsonProperty(value="phone_number")
    private String phoneNumber = null;
    @JsonProperty(value="birthday")
    private String birthday = null;
    @JsonProperty(value="reference_id")
    private String referenceId = null;
    @JsonProperty(value="note")
    private String note = null;
    @JsonProperty(value="preferences")
    private CustomerPreferences preferences = null;
    @JsonProperty(value="groups")
    private List<CustomerGroupInfo> groups = new ArrayList<CustomerGroupInfo>();
    @JsonProperty(value="creation_source")
    private CreationSourceEnum creationSource = null;

    public Customer id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The customer's unique ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Customer createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The time when the customer was created, in RFC 3339 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Customer updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The time when the customer was last updated, in RFC 3339 format.")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Customer cards(List<Card> cards) {
        this.cards = cards;
        return this;
    }

    public Customer addCardsItem(Card cardsItem) {
        this.cards.add(cardsItem);
        return this;
    }

    @ApiModelProperty(value="The payment details of the customer's cards on file.")
    public List<Card> getCards() {
        return this.cards;
    }

    public void setCards(List<Card> cards) {
        this.cards = cards;
    }

    public Customer givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @ApiModelProperty(value="The customer's given (i.e., first) name.")
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public Customer familyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    @ApiModelProperty(value="The customer's family (i.e., last) name.")
    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public Customer nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @ApiModelProperty(value="The customer's nickname.")
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Customer companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @ApiModelProperty(value="The name of the customer's company.")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Customer emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @ApiModelProperty(value="The customer's email address.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Customer address(Address address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="The customer's physical address.")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Customer phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="The customer's phone number.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Customer birthday(String birthday) {
        this.birthday = birthday;
        return this;
    }

    @ApiModelProperty(value="The customer's birthday in RFC-3339 format. Year is optional, timezone and times are not allowed. Example: `0000-09-01T00:00:00-00:00` for a birthday on September 1st. `1998-09-01T00:00:00-00:00` for a birthday on September 1st 1998.")
    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public Customer referenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    @ApiModelProperty(value="A second ID you can set to associate the customer with an entity in another system.")
    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public Customer note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(value="A note to associate with the customer.")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Customer preferences(CustomerPreferences preferences) {
        this.preferences = preferences;
        return this;
    }

    @ApiModelProperty(value="The customer's preferences.")
    public CustomerPreferences getPreferences() {
        return this.preferences;
    }

    public void setPreferences(CustomerPreferences preferences) {
        this.preferences = preferences;
    }

    public Customer groups(List<CustomerGroupInfo> groups) {
        this.groups = groups;
        return this;
    }

    public Customer addGroupsItem(CustomerGroupInfo groupsItem) {
        this.groups.add(groupsItem);
        return this;
    }

    @ApiModelProperty(value="The groups the customer belongs to.")
    public List<CustomerGroupInfo> getGroups() {
        return this.groups;
    }

    public void setGroups(List<CustomerGroupInfo> groups) {
        this.groups = groups;
    }

    public Customer creationSource(CreationSourceEnum creationSource) {
        this.creationSource = creationSource;
        return this;
    }

    @ApiModelProperty(value="A creation source represents the method used to create the customer profile. See [CustomerCreationSource](#type-customercreationsource) for possible values")
    public CreationSourceEnum getCreationSource() {
        return this.creationSource;
    }

    public void setCreationSource(CreationSourceEnum creationSource) {
        this.creationSource = creationSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Customer customer = (Customer)o;
        return Objects.equals(this.id, customer.id) && Objects.equals(this.createdAt, customer.createdAt) && Objects.equals(this.updatedAt, customer.updatedAt) && Objects.equals(this.cards, customer.cards) && Objects.equals(this.givenName, customer.givenName) && Objects.equals(this.familyName, customer.familyName) && Objects.equals(this.nickname, customer.nickname) && Objects.equals(this.companyName, customer.companyName) && Objects.equals(this.emailAddress, customer.emailAddress) && Objects.equals(this.address, customer.address) && Objects.equals(this.phoneNumber, customer.phoneNumber) && Objects.equals(this.birthday, customer.birthday) && Objects.equals(this.referenceId, customer.referenceId) && Objects.equals(this.note, customer.note) && Objects.equals(this.preferences, customer.preferences) && Objects.equals(this.groups, customer.groups) && Objects.equals((Object)this.creationSource, (Object)customer.creationSource);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdAt, this.updatedAt, this.cards, this.givenName, this.familyName, this.nickname, this.companyName, this.emailAddress, this.address, this.phoneNumber, this.birthday, this.referenceId, this.note, this.preferences, this.groups, this.creationSource});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Customer {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    cards: ").append(this.toIndentedString(this.cards)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    birthday: ").append(this.toIndentedString(this.birthday)).append("\n");
        sb.append("    referenceId: ").append(this.toIndentedString(this.referenceId)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    preferences: ").append(this.toIndentedString(this.preferences)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    creationSource: ").append(this.toIndentedString((Object)this.creationSource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CreationSourceEnum {
        OTHER("OTHER"),
        APPOINTMENTS("APPOINTMENTS"),
        COUPON("COUPON"),
        DELETION_RECOVERY("DELETION_RECOVERY"),
        DIRECTORY("DIRECTORY"),
        EGIFTING("EGIFTING"),
        EMAIL_COLLECTION("EMAIL_COLLECTION"),
        FEEDBACK("FEEDBACK"),
        IMPORT("IMPORT"),
        INVOICES("INVOICES"),
        LOYALTY("LOYALTY"),
        MARKETING("MARKETING"),
        MERGE("MERGE"),
        ONLINE_STORE("ONLINE_STORE"),
        INSTANT_PROFILE("INSTANT_PROFILE"),
        TERMINAL("TERMINAL"),
        THIRD_PARTY("THIRD_PARTY"),
        THIRD_PARTY_IMPORT("THIRD_PARTY_IMPORT"),
        UNMERGE_RECOVERY("UNMERGE_RECOVERY");

        private String value;

        private CreationSourceEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CreationSourceEnum fromValue(String text) {
            for (CreationSourceEnum b : CreationSourceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

