/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.CustomerFilter;
import com.squareup.connect.models.CustomerSort;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a query (filtering and sorting criteria) used to search for customer profiles.")
public class CustomerQuery {
    @JsonProperty(value="filter")
    private CustomerFilter filter = null;
    @JsonProperty(value="sort")
    private CustomerSort sort = null;

    public CustomerQuery filter(CustomerFilter filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(value="A list of filter criteria.")
    public CustomerFilter getFilter() {
        return this.filter;
    }

    public void setFilter(CustomerFilter filter) {
        this.filter = filter;
    }

    public CustomerQuery sort(CustomerSort sort) {
        this.sort = sort;
        return this;
    }

    @ApiModelProperty(value="Sort criteria for query results. The default sort behavior is to order customers alphabetically by `given_name` and `last_name`.")
    public CustomerSort getSort() {
        return this.sort;
    }

    public void setSort(CustomerSort sort) {
        this.sort = sort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerQuery customerQuery = (CustomerQuery)o;
        return Objects.equals(this.filter, customerQuery.filter) && Objects.equals(this.sort, customerQuery.sort);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerQuery {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

