/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Indicates the field to use for sorting customer profiles. For example, by total money spent with the merchant or the date of their first purchase.")
public class CustomerSort {
    @JsonProperty(value="field")
    private FieldEnum field = null;
    @JsonProperty(value="order")
    private OrderEnum order = null;

    public CustomerSort field(FieldEnum field) {
        this.field = field;
        return this;
    }

    @ApiModelProperty(value="The field to sort the results on. It could be the total money spent at the merchant, the date of the first visit (etc). See [CustomerSortField](#type-customersortfield) for possible values")
    public FieldEnum getField() {
        return this.field;
    }

    public void setField(FieldEnum field) {
        this.field = field;
    }

    public CustomerSort order(OrderEnum order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(value="Indicates the order in which results should be displayed based on the value of the sort field. String comparisons use standard alphabetic comparison to determine order. Strings representing numbers are sorted as strings. See [SortOrder](#type-sortorder) for possible values")
    public OrderEnum getOrder() {
        return this.order;
    }

    public void setOrder(OrderEnum order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerSort customerSort = (CustomerSort)o;
        return Objects.equals((Object)this.field, (Object)customerSort.field) && Objects.equals((Object)this.order, (Object)customerSort.order);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.order});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerSort {\n");
        sb.append("    field: ").append(this.toIndentedString((Object)this.field)).append("\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OrderEnum {
        DESC("DESC"),
        ASC("ASC");

        private String value;

        private OrderEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OrderEnum fromValue(String text) {
            for (OrderEnum b : OrderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum FieldEnum {
        DEFAULT("DEFAULT"),
        CREATED_AT("CREATED_AT");

        private String value;

        private FieldEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FieldEnum fromValue(String text) {
            for (FieldEnum b : FieldEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

