/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A range defined by two dates. Used for filtering a query for Connect v2  objects that have date properties.")
public class DateRange {
    @JsonProperty(value="start_date")
    private String startDate = null;
    @JsonProperty(value="end_date")
    private String endDate = null;

    public DateRange startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(value="String in `YYYY-MM-DD` format, e.g. `2017-10-31` per the ISO 8601 extended format for calendar dates. The beginning of a date range (inclusive)")
    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public DateRange endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="String in `YYYY-MM-DD` format, e.g. `2017-10-31` per the ISO 8601 extended format for calendar dates. The end of a date range (inclusive)")
    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateRange dateRange = (DateRange)o;
        return Objects.equals(this.startDate, dateRange.startDate) && Objects.equals(this.endDate, dateRange.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DateRange {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

