/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="An employee created in the **Square Dashboard** account of a business.  Used by the Labor API.")
public class Employee {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="first_name")
    private String firstName = null;
    @JsonProperty(value="last_name")
    private String lastName = null;
    @JsonProperty(value="location_ids")
    private List<String> locationIds = new ArrayList<String>();
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="updated_at")
    private String updatedAt = null;

    public Employee id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="UUID for this `Employee`.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Employee firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(value="Given (first) name of the employee.")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Employee lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(value="Family (last) name of the employee")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Employee locationIds(List<String> locationIds) {
        this.locationIds = locationIds;
        return this;
    }

    public Employee addLocationIdsItem(String locationIdsItem) {
        this.locationIds.add(locationIdsItem);
        return this;
    }

    @ApiModelProperty(value="A list of location IDs where this employee has access.")
    public List<String> getLocationIds() {
        return this.locationIds;
    }

    public void setLocationIds(List<String> locationIds) {
        this.locationIds = locationIds;
    }

    public Employee status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Specifies the status of the employee being fetched. See [EmployeeStatus](#type-employeestatus) for possible values")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Employee createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="A read-only timestamp in RFC 3339 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Employee updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="A read-only timestamp in RFC 3339 format.")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Employee employee = (Employee)o;
        return Objects.equals(this.id, employee.id) && Objects.equals(this.firstName, employee.firstName) && Objects.equals(this.lastName, employee.lastName) && Objects.equals(this.locationIds, employee.locationIds) && Objects.equals((Object)this.status, (Object)employee.status) && Objects.equals(this.createdAt, employee.createdAt) && Objects.equals(this.updatedAt, employee.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.firstName, this.lastName, this.locationIds, this.status, this.createdAt, this.updatedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Employee {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    locationIds: ").append(this.toIndentedString(this.locationIds)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

