/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The hourly wage rate that an employee will earn on a `Shift` for doing the job specified by the `title` property of this object.")
public class EmployeeWage {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="employee_id")
    private String employeeId = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="hourly_rate")
    private Money hourlyRate = null;

    public EmployeeWage id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="UUID for this object.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EmployeeWage employeeId(String employeeId) {
        this.employeeId = employeeId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `Employee` that this wage is assigned to.")
    public String getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public EmployeeWage title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="The job title that this wage relates to.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public EmployeeWage hourlyRate(Money hourlyRate) {
        this.hourlyRate = hourlyRate;
        return this;
    }

    @ApiModelProperty(value="Can be a custom-set hourly wage or the calculated effective hourly wage based on annual wage and hours worked per week.")
    public Money getHourlyRate() {
        return this.hourlyRate;
    }

    public void setHourlyRate(Money hourlyRate) {
        this.hourlyRate = hourlyRate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmployeeWage employeeWage = (EmployeeWage)o;
        return Objects.equals(this.id, employeeWage.id) && Objects.equals(this.employeeId, employeeWage.employeeId) && Objects.equals(this.title, employeeWage.title) && Objects.equals(this.hourlyRate, employeeWage.hourlyRate);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.employeeId, this.title, this.hourlyRate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmployeeWage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    employeeId: ").append(this.toIndentedString(this.employeeId)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    hourlyRate: ").append(this.toIndentedString(this.hourlyRate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

