/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents an error encountered during a request to the Connect API.")
public class Error {
    @JsonProperty(value="category")
    private CategoryEnum category = null;
    @JsonProperty(value="code")
    private CodeEnum code = null;
    @JsonProperty(value="detail")
    private String detail = null;
    @JsonProperty(value="field")
    private String field = null;

    public Error category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(required=true, value="The error's high-level category. See [ErrorCategory](#type-errorcategory) for possible values")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public Error code(CodeEnum code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(required=true, value="The error's specific code. See [ErrorCode](#type-errorcode) for possible values")
    public CodeEnum getCode() {
        return this.code;
    }

    public void setCode(CodeEnum code) {
        this.code = code;
    }

    public Error detail(String detail) {
        this.detail = detail;
        return this;
    }

    @ApiModelProperty(value="A human-readable description of the error for debugging purposes.")
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Error field(String field) {
        this.field = field;
        return this;
    }

    @ApiModelProperty(value="The name of the field provided in the original request that the error pertains to, if any.")
    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals((Object)this.category, (Object)error.category) && Objects.equals((Object)this.code, (Object)error.code) && Objects.equals(this.detail, error.detail) && Objects.equals(this.field, error.field);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.code, this.detail, this.field});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    code: ").append(this.toIndentedString((Object)this.code)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CodeEnum {
        INTERNAL_SERVER_ERROR("INTERNAL_SERVER_ERROR"),
        UNAUTHORIZED("UNAUTHORIZED"),
        ACCESS_TOKEN_EXPIRED("ACCESS_TOKEN_EXPIRED"),
        ACCESS_TOKEN_REVOKED("ACCESS_TOKEN_REVOKED"),
        FORBIDDEN("FORBIDDEN"),
        INSUFFICIENT_SCOPES("INSUFFICIENT_SCOPES"),
        APPLICATION_DISABLED("APPLICATION_DISABLED"),
        V1_APPLICATION("V1_APPLICATION"),
        V1_ACCESS_TOKEN("V1_ACCESS_TOKEN"),
        CARD_PROCESSING_NOT_ENABLED("CARD_PROCESSING_NOT_ENABLED"),
        BAD_REQUEST("BAD_REQUEST"),
        MISSING_REQUIRED_PARAMETER("MISSING_REQUIRED_PARAMETER"),
        INCORRECT_TYPE("INCORRECT_TYPE"),
        INVALID_TIME("INVALID_TIME"),
        INVALID_TIME_RANGE("INVALID_TIME_RANGE"),
        INVALID_VALUE("INVALID_VALUE"),
        INVALID_CURSOR("INVALID_CURSOR"),
        UNKNOWN_QUERY_PARAMETER("UNKNOWN_QUERY_PARAMETER"),
        CONFLICTING_PARAMETERS("CONFLICTING_PARAMETERS"),
        EXPECTED_JSON_BODY("EXPECTED_JSON_BODY"),
        INVALID_SORT_ORDER("INVALID_SORT_ORDER"),
        VALUE_REGEX_MISMATCH("VALUE_REGEX_MISMATCH"),
        VALUE_TOO_SHORT("VALUE_TOO_SHORT"),
        VALUE_TOO_LONG("VALUE_TOO_LONG"),
        VALUE_TOO_LOW("VALUE_TOO_LOW"),
        VALUE_TOO_HIGH("VALUE_TOO_HIGH"),
        VALUE_EMPTY("VALUE_EMPTY"),
        ARRAY_LENGTH_TOO_LONG("ARRAY_LENGTH_TOO_LONG"),
        ARRAY_LENGTH_TOO_SHORT("ARRAY_LENGTH_TOO_SHORT"),
        ARRAY_EMPTY("ARRAY_EMPTY"),
        EXPECTED_BOOLEAN("EXPECTED_BOOLEAN"),
        EXPECTED_INTEGER("EXPECTED_INTEGER"),
        EXPECTED_FLOAT("EXPECTED_FLOAT"),
        EXPECTED_STRING("EXPECTED_STRING"),
        EXPECTED_OBJECT("EXPECTED_OBJECT"),
        EXPECTED_ARRAY("EXPECTED_ARRAY"),
        EXPECTED_MAP("EXPECTED_MAP"),
        EXPECTED_BASE64_ENCODED_BYTE_ARRAY("EXPECTED_BASE64_ENCODED_BYTE_ARRAY"),
        INVALID_ARRAY_VALUE("INVALID_ARRAY_VALUE"),
        INVALID_ENUM_VALUE("INVALID_ENUM_VALUE"),
        INVALID_CONTENT_TYPE("INVALID_CONTENT_TYPE"),
        INVALID_FORM_VALUE("INVALID_FORM_VALUE"),
        ONE_INSTRUMENT_EXPECTED("ONE_INSTRUMENT_EXPECTED"),
        NO_FIELDS_SET("NO_FIELDS_SET"),
        DEPRECATED_FIELD_SET("DEPRECATED_FIELD_SET"),
        CARD_EXPIRED("CARD_EXPIRED"),
        INVALID_EXPIRATION("INVALID_EXPIRATION"),
        INVALID_EXPIRATION_YEAR("INVALID_EXPIRATION_YEAR"),
        INVALID_EXPIRATION_DATE("INVALID_EXPIRATION_DATE"),
        UNSUPPORTED_CARD_BRAND("UNSUPPORTED_CARD_BRAND"),
        UNSUPPORTED_ENTRY_METHOD("UNSUPPORTED_ENTRY_METHOD"),
        INVALID_ENCRYPTED_CARD("INVALID_ENCRYPTED_CARD"),
        INVALID_CARD("INVALID_CARD"),
        DELAYED_TRANSACTION_EXPIRED("DELAYED_TRANSACTION_EXPIRED"),
        DELAYED_TRANSACTION_CANCELED("DELAYED_TRANSACTION_CANCELED"),
        DELAYED_TRANSACTION_CAPTURED("DELAYED_TRANSACTION_CAPTURED"),
        DELAYED_TRANSACTION_FAILED("DELAYED_TRANSACTION_FAILED"),
        CARD_TOKEN_EXPIRED("CARD_TOKEN_EXPIRED"),
        CARD_TOKEN_USED("CARD_TOKEN_USED"),
        AMOUNT_TOO_HIGH("AMOUNT_TOO_HIGH"),
        UNSUPPORTED_INSTRUMENT_TYPE("UNSUPPORTED_INSTRUMENT_TYPE"),
        REFUND_AMOUNT_INVALID("REFUND_AMOUNT_INVALID"),
        REFUND_ALREADY_PENDING("REFUND_ALREADY_PENDING"),
        PAYMENT_NOT_REFUNDABLE("PAYMENT_NOT_REFUNDABLE"),
        INVALID_CARD_DATA("INVALID_CARD_DATA"),
        LOCATION_MISMATCH("LOCATION_MISMATCH"),
        IDEMPOTENCY_KEY_REUSED("IDEMPOTENCY_KEY_REUSED"),
        UNEXPECTED_VALUE("UNEXPECTED_VALUE"),
        SANDBOX_NOT_SUPPORTED("SANDBOX_NOT_SUPPORTED"),
        INVALID_EMAIL_ADDRESS("INVALID_EMAIL_ADDRESS"),
        INVALID_PHONE_NUMBER("INVALID_PHONE_NUMBER"),
        CHECKOUT_EXPIRED("CHECKOUT_EXPIRED"),
        BAD_CERTIFICATE("BAD_CERTIFICATE"),
        CARD_DECLINED("CARD_DECLINED"),
        VERIFY_CVV_FAILURE("VERIFY_CVV_FAILURE"),
        VERIFY_AVS_FAILURE("VERIFY_AVS_FAILURE"),
        CARD_DECLINED_CALL_ISSUER("CARD_DECLINED_CALL_ISSUER"),
        NOT_FOUND("NOT_FOUND"),
        APPLE_PAYMENT_PROCESSING_CERTIFICATE_HASH_NOT_FOUND("APPLE_PAYMENT_PROCESSING_CERTIFICATE_HASH_NOT_FOUND"),
        METHOD_NOT_ALLOWED("METHOD_NOT_ALLOWED"),
        NOT_ACCEPTABLE("NOT_ACCEPTABLE"),
        REQUEST_TIMEOUT("REQUEST_TIMEOUT"),
        CONFLICT("CONFLICT"),
        REQUEST_ENTITY_TOO_LARGE("REQUEST_ENTITY_TOO_LARGE"),
        UNSUPPORTED_MEDIA_TYPE("UNSUPPORTED_MEDIA_TYPE"),
        RATE_LIMITED("RATE_LIMITED"),
        NOT_IMPLEMENTED("NOT_IMPLEMENTED"),
        SERVICE_UNAVAILABLE("SERVICE_UNAVAILABLE"),
        GATEWAY_TIMEOUT("GATEWAY_TIMEOUT");

        private String value;

        private CodeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CodeEnum fromValue(String text) {
            for (CodeEnum b : CodeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum CategoryEnum {
        API_ERROR("API_ERROR"),
        AUTHENTICATION_ERROR("AUTHENTICATION_ERROR"),
        INVALID_REQUEST_ERROR("INVALID_REQUEST_ERROR"),
        RATE_LIMIT_ERROR("RATE_LIMIT_ERROR"),
        PAYMENT_METHOD_ERROR("PAYMENT_METHOD_ERROR"),
        REFUND_ERROR("REFUND_ERROR");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String text) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

