/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents the estimated quantity of items in a particular state at a particular location based on the known history of physical counts and inventory adjustments.")
public class InventoryCount {
    @JsonProperty(value="catalog_object_id")
    private String catalogObjectId = null;
    @JsonProperty(value="catalog_object_type")
    private String catalogObjectType = null;
    @JsonProperty(value="state")
    private StateEnum state = null;
    @JsonProperty(value="location_id")
    private String locationId = null;
    @JsonProperty(value="quantity")
    private String quantity = null;
    @JsonProperty(value="calculated_at")
    private String calculatedAt = null;

    public InventoryCount catalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
        return this;
    }

    @ApiModelProperty(value="The Square generated ID of the [CatalogObject](#type-catalogobject) being tracked.")
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    public void setCatalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
    }

    public InventoryCount catalogObjectType(String catalogObjectType) {
        this.catalogObjectType = catalogObjectType;
        return this;
    }

    @ApiModelProperty(value="The [CatalogObjectType](#type-catalogobjecttype) of the [CatalogObject](#type-catalogobject) being tracked. Tracking is only supported for the `ITEM_VARIATION` type.")
    public String getCatalogObjectType() {
        return this.catalogObjectType;
    }

    public void setCatalogObjectType(String catalogObjectType) {
        this.catalogObjectType = catalogObjectType;
    }

    public InventoryCount state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="The current [InventoryState](#type-inventorystate) for the related quantity of items. See [InventoryState](#type-inventorystate) for possible values")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public InventoryCount locationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    @ApiModelProperty(value="The Square ID of the [Location](#type-location) where the related quantity of items are being tracked.")
    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public InventoryCount quantity(String quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(value="The number of items in the count as a decimal string. Fractional quantities are not supported.")
    public String getQuantity() {
        return this.quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public InventoryCount calculatedAt(String calculatedAt) {
        this.calculatedAt = calculatedAt;
        return this;
    }

    @ApiModelProperty(value="A read-only timestamp in RFC 3339 format that indicates when Square received the most recent physical count or adjustment that had an affect on the estimated count.")
    public String getCalculatedAt() {
        return this.calculatedAt;
    }

    public void setCalculatedAt(String calculatedAt) {
        this.calculatedAt = calculatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryCount inventoryCount = (InventoryCount)o;
        return Objects.equals(this.catalogObjectId, inventoryCount.catalogObjectId) && Objects.equals(this.catalogObjectType, inventoryCount.catalogObjectType) && Objects.equals((Object)this.state, (Object)inventoryCount.state) && Objects.equals(this.locationId, inventoryCount.locationId) && Objects.equals(this.quantity, inventoryCount.quantity) && Objects.equals(this.calculatedAt, inventoryCount.calculatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.catalogObjectId, this.catalogObjectType, this.state, this.locationId, this.quantity, this.calculatedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InventoryCount {\n");
        sb.append("    catalogObjectId: ").append(this.toIndentedString(this.catalogObjectId)).append("\n");
        sb.append("    catalogObjectType: ").append(this.toIndentedString(this.catalogObjectType)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    calculatedAt: ").append(this.toIndentedString(this.calculatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        CUSTOM("CUSTOM"),
        IN_STOCK("IN_STOCK"),
        SOLD("SOLD"),
        RETURNED_BY_CUSTOMER("RETURNED_BY_CUSTOMER"),
        RESERVED_FOR_SALE("RESERVED_FOR_SALE"),
        SOLD_ONLINE("SOLD_ONLINE"),
        ORDERED_FROM_VENDOR("ORDERED_FROM_VENDOR"),
        RECEIVED_FROM_VENDOR("RECEIVED_FROM_VENDOR"),
        IN_TRANSIT_TO("IN_TRANSIT_TO"),
        NONE("NONE"),
        WASTE("WASTE"),
        UNLINKED_RETURN("UNLINKED_RETURN");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

