/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Price and inventory alerting overrides for a [CatalogItemVariation](#type-catalogitemvariation) at a specific [location](#type-location).")
public class ItemVariationLocationOverrides {
    @JsonProperty(value="location_id")
    private String locationId = null;
    @JsonProperty(value="price_money")
    private Money priceMoney = null;
    @JsonProperty(value="pricing_type")
    private PricingTypeEnum pricingType = null;
    @JsonProperty(value="track_inventory")
    private Boolean trackInventory = null;
    @JsonProperty(value="inventory_alert_type")
    private InventoryAlertTypeEnum inventoryAlertType = null;
    @JsonProperty(value="inventory_alert_threshold")
    private Long inventoryAlertThreshold = null;

    public ItemVariationLocationOverrides locationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    @ApiModelProperty(value="The ID of the [location](#type-location).")
    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public ItemVariationLocationOverrides priceMoney(Money priceMoney) {
        this.priceMoney = priceMoney;
        return this;
    }

    @ApiModelProperty(value="The price of the [CatalogItemVariation](#type-catalogitemvariation) at the given [location](#type-location), or blank for variable pricing.")
    public Money getPriceMoney() {
        return this.priceMoney;
    }

    public void setPriceMoney(Money priceMoney) {
        this.priceMoney = priceMoney;
    }

    public ItemVariationLocationOverrides pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @ApiModelProperty(value="The pricing type (fixed or variable) for the [CatalogItemVariation](#type-catalogitemvariation) at the given [location](#type-location). See [CatalogPricingType](#type-catalogpricingtype) for possible values")
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public ItemVariationLocationOverrides trackInventory(Boolean trackInventory) {
        this.trackInventory = trackInventory;
        return this;
    }

    @ApiModelProperty(value="If `true`, inventory tracking is active for the [CatalogItemVariation](#type-catalogitemvariation) at this [location](#type-location).")
    public Boolean getTrackInventory() {
        return this.trackInventory;
    }

    public void setTrackInventory(Boolean trackInventory) {
        this.trackInventory = trackInventory;
    }

    public ItemVariationLocationOverrides inventoryAlertType(InventoryAlertTypeEnum inventoryAlertType) {
        this.inventoryAlertType = inventoryAlertType;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the [CatalogItemVariation](#type-catalogitemvariation) displays an alert when its inventory quantity is less than or equal to its `inventory_alert_threshold`. See [InventoryAlertType](#type-inventoryalerttype) for possible values")
    public InventoryAlertTypeEnum getInventoryAlertType() {
        return this.inventoryAlertType;
    }

    public void setInventoryAlertType(InventoryAlertTypeEnum inventoryAlertType) {
        this.inventoryAlertType = inventoryAlertType;
    }

    public ItemVariationLocationOverrides inventoryAlertThreshold(Long inventoryAlertThreshold) {
        this.inventoryAlertThreshold = inventoryAlertThreshold;
        return this;
    }

    @ApiModelProperty(value="If the inventory quantity for the variation is less than or equal to this value and `inventory_alert_type` is `LOW_QUANTITY`, the variation displays an alert in the merchant dashboard.  This value is always an integer.")
    public Long getInventoryAlertThreshold() {
        return this.inventoryAlertThreshold;
    }

    public void setInventoryAlertThreshold(Long inventoryAlertThreshold) {
        this.inventoryAlertThreshold = inventoryAlertThreshold;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemVariationLocationOverrides itemVariationLocationOverrides = (ItemVariationLocationOverrides)o;
        return Objects.equals(this.locationId, itemVariationLocationOverrides.locationId) && Objects.equals(this.priceMoney, itemVariationLocationOverrides.priceMoney) && Objects.equals((Object)this.pricingType, (Object)itemVariationLocationOverrides.pricingType) && Objects.equals(this.trackInventory, itemVariationLocationOverrides.trackInventory) && Objects.equals((Object)this.inventoryAlertType, (Object)itemVariationLocationOverrides.inventoryAlertType) && Objects.equals(this.inventoryAlertThreshold, itemVariationLocationOverrides.inventoryAlertThreshold);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.locationId, this.priceMoney, this.pricingType, this.trackInventory, this.inventoryAlertType, this.inventoryAlertThreshold});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemVariationLocationOverrides {\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    priceMoney: ").append(this.toIndentedString(this.priceMoney)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    trackInventory: ").append(this.toIndentedString(this.trackInventory)).append("\n");
        sb.append("    inventoryAlertType: ").append(this.toIndentedString((Object)this.inventoryAlertType)).append("\n");
        sb.append("    inventoryAlertThreshold: ").append(this.toIndentedString(this.inventoryAlertThreshold)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InventoryAlertTypeEnum {
        NONE("NONE"),
        LOW_QUANTITY("LOW_QUANTITY");

        private String value;

        private InventoryAlertTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InventoryAlertTypeEnum fromValue(String text) {
            for (InventoryAlertTypeEnum b : InventoryAlertTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum PricingTypeEnum {
        FIXED_PRICING("FIXED_PRICING"),
        VARIABLE_PRICING("VARIABLE_PRICING");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String text) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

