/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Retrieve a paged-list of employees for a Square account")
public class ListEmployeesRequest {
    @JsonProperty(value="location_id")
    private String locationId = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="limit")
    private Integer limit = null;
    @JsonProperty(value="cursor")
    private String cursor = null;

    public ListEmployeesRequest locationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    @ApiModelProperty(value="Filter employees returned to only those that are associated with the specified location.")
    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public ListEmployeesRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Specifies the EmployeeStatus to filter the employee by. See [EmployeeStatus](#type-employeestatus) for possible values")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ListEmployeesRequest limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(value="The number of employees to be returned on each page.")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public ListEmployeesRequest cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @ApiModelProperty(value="The token required to retrieve the specified page of results.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListEmployeesRequest listEmployeesRequest = (ListEmployeesRequest)o;
        return Objects.equals(this.locationId, listEmployeesRequest.locationId) && Objects.equals((Object)this.status, (Object)listEmployeesRequest.status) && Objects.equals(this.limit, listEmployeesRequest.limit) && Objects.equals(this.cursor, listEmployeesRequest.cursor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.locationId, this.status, this.limit, this.cursor});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListEmployeesRequest {\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

