/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Employee;
import com.squareup.connect.models.Error;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines the fields that are included in the response body of a request to the [ListEmployees](#endpoint-listemployees) endpoint.  One of `errors` or `employees` is present in a given response (never both).")
public class ListEmployeesResponse {
    @JsonProperty(value="employees")
    private List<Employee> employees = new ArrayList<Employee>();
    @JsonProperty(value="cursor")
    private String cursor = null;
    @JsonProperty(value="errors")
    private List<Error> errors = new ArrayList<Error>();

    public ListEmployeesResponse employees(List<Employee> employees) {
        this.employees = employees;
        return this;
    }

    public ListEmployeesResponse addEmployeesItem(Employee employeesItem) {
        this.employees.add(employeesItem);
        return this;
    }

    @ApiModelProperty(value="List of employees returned from the request.")
    public List<Employee> getEmployees() {
        return this.employees;
    }

    public void setEmployees(List<Employee> employees) {
        this.employees = employees;
    }

    public ListEmployeesResponse cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @ApiModelProperty(value="The token to be used to retrieve the next page of results.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public ListEmployeesResponse errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public ListEmployeesResponse addErrorsItem(Error errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="Any errors that occurred during the request.")
    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListEmployeesResponse listEmployeesResponse = (ListEmployeesResponse)o;
        return Objects.equals(this.employees, listEmployeesResponse.employees) && Objects.equals(this.cursor, listEmployeesResponse.cursor) && Objects.equals(this.errors, listEmployeesResponse.errors);
    }

    public int hashCode() {
        return Objects.hash(this.employees, this.cursor, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListEmployeesResponse {\n");
        sb.append("    employees: ").append(this.toIndentedString(this.employees)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

