/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Error;
import com.squareup.connect.models.Refund;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines the fields that are included in the response body of a request to the [ListRefunds](#endpoint-listrefunds) endpoint.  One of `errors` or `refunds` is present in a given response (never both).")
public class ListRefundsResponse {
    @JsonProperty(value="errors")
    private List<Error> errors = new ArrayList<Error>();
    @JsonProperty(value="refunds")
    private List<Refund> refunds = new ArrayList<Refund>();
    @JsonProperty(value="cursor")
    private String cursor = null;

    public ListRefundsResponse errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public ListRefundsResponse addErrorsItem(Error errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="Any errors that occurred during the request.")
    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public ListRefundsResponse refunds(List<Refund> refunds) {
        this.refunds = refunds;
        return this;
    }

    public ListRefundsResponse addRefundsItem(Refund refundsItem) {
        this.refunds.add(refundsItem);
        return this;
    }

    @ApiModelProperty(value="An array of refunds that match your query.")
    public List<Refund> getRefunds() {
        return this.refunds;
    }

    public void setRefunds(List<Refund> refunds) {
        this.refunds = refunds;
    }

    public ListRefundsResponse cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @ApiModelProperty(value="A pagination cursor for retrieving the next set of results, if any remain. Provide this value as the `cursor` parameter in a subsequent request to this endpoint.  See [Pagination](/basics/api101/pagination) for more information.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListRefundsResponse listRefundsResponse = (ListRefundsResponse)o;
        return Objects.equals(this.errors, listRefundsResponse.errors) && Objects.equals(this.refunds, listRefundsResponse.refunds) && Objects.equals(this.cursor, listRefundsResponse.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.refunds, this.cursor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListRefundsResponse {\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    refunds: ").append(this.toIndentedString(this.refunds)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

