/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Error;
import com.squareup.connect.models.WorkweekConfig;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The response to a request for a set of `WorkweekConfig` objects. Contains the requested `WorkweekConfig` objects. May contain a set of `Error` objects if the request resulted in errors.")
public class ListWorkweekConfigsResponse {
    @JsonProperty(value="workweek_configs")
    private List<WorkweekConfig> workweekConfigs = new ArrayList<WorkweekConfig>();
    @JsonProperty(value="cursor")
    private String cursor = null;
    @JsonProperty(value="errors")
    private List<Error> errors = new ArrayList<Error>();

    public ListWorkweekConfigsResponse workweekConfigs(List<WorkweekConfig> workweekConfigs) {
        this.workweekConfigs = workweekConfigs;
        return this;
    }

    public ListWorkweekConfigsResponse addWorkweekConfigsItem(WorkweekConfig workweekConfigsItem) {
        this.workweekConfigs.add(workweekConfigsItem);
        return this;
    }

    @ApiModelProperty(value="A page of Employee Wage results.")
    public List<WorkweekConfig> getWorkweekConfigs() {
        return this.workweekConfigs;
    }

    public void setWorkweekConfigs(List<WorkweekConfig> workweekConfigs) {
        this.workweekConfigs = workweekConfigs;
    }

    public ListWorkweekConfigsResponse cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @ApiModelProperty(value="Value supplied in the subsequent request to fetch the next page of Employee Wage results.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public ListWorkweekConfigsResponse errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public ListWorkweekConfigsResponse addErrorsItem(Error errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="Any errors that occurred during the request.")
    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListWorkweekConfigsResponse listWorkweekConfigsResponse = (ListWorkweekConfigsResponse)o;
        return Objects.equals(this.workweekConfigs, listWorkweekConfigsResponse.workweekConfigs) && Objects.equals(this.cursor, listWorkweekConfigsResponse.cursor) && Objects.equals(this.errors, listWorkweekConfigsResponse.errors);
    }

    public int hashCode() {
        return Objects.hash(this.workweekConfigs, this.cursor, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListWorkweekConfigsResponse {\n");
        sb.append("    workweekConfigs: ").append(this.toIndentedString(this.workweekConfigs)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

