/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A record of an employee's break during a shift.")
public class ModelBreak {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="start_at")
    private String startAt = null;
    @JsonProperty(value="end_at")
    private String endAt = null;
    @JsonProperty(value="break_type_id")
    private String breakTypeId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="expected_duration")
    private String expectedDuration = null;
    @JsonProperty(value="is_paid")
    private Boolean isPaid = null;

    public ModelBreak id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="UUID for this object")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ModelBreak startAt(String startAt) {
        this.startAt = startAt;
        return this;
    }

    @ApiModelProperty(required=true, value="RFC 3339; follows same timezone info as `Shift`. Precision up to the minute is respected; seconds are truncated.")
    public String getStartAt() {
        return this.startAt;
    }

    public void setStartAt(String startAt) {
        this.startAt = startAt;
    }

    public ModelBreak endAt(String endAt) {
        this.endAt = endAt;
        return this;
    }

    @ApiModelProperty(value="RFC 3339; follows same timezone info as `Shift`. Precision up to the minute is respected; seconds are truncated. The `end_at` minute is not counted when the break length is calculated. For example, a break from `00:00` to `00:11`  is considered a 10 minute break (midnight to 10 minutes after midnight).")
    public String getEndAt() {
        return this.endAt;
    }

    public void setEndAt(String endAt) {
        this.endAt = endAt;
    }

    public ModelBreak breakTypeId(String breakTypeId) {
        this.breakTypeId = breakTypeId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `BreakType` this `Break` was templated on.")
    public String getBreakTypeId() {
        return this.breakTypeId;
    }

    public void setBreakTypeId(String breakTypeId) {
        this.breakTypeId = breakTypeId;
    }

    public ModelBreak name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="A human-readable name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModelBreak expectedDuration(String expectedDuration) {
        this.expectedDuration = expectedDuration;
        return this;
    }

    @ApiModelProperty(required=true, value="Format: RFC-3339 P[n]Y[n]M[n]DT[n]H[n]M[n]S. The expected length of the break.")
    public String getExpectedDuration() {
        return this.expectedDuration;
    }

    public void setExpectedDuration(String expectedDuration) {
        this.expectedDuration = expectedDuration;
    }

    public ModelBreak isPaid(Boolean isPaid) {
        this.isPaid = isPaid;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether this break counts towards time worked for compensation purposes.")
    public Boolean getIsPaid() {
        return this.isPaid;
    }

    public void setIsPaid(Boolean isPaid) {
        this.isPaid = isPaid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelBreak _break = (ModelBreak)o;
        return Objects.equals(this.id, _break.id) && Objects.equals(this.startAt, _break.startAt) && Objects.equals(this.endAt, _break.endAt) && Objects.equals(this.breakTypeId, _break.breakTypeId) && Objects.equals(this.name, _break.name) && Objects.equals(this.expectedDuration, _break.expectedDuration) && Objects.equals(this.isPaid, _break.isPaid);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.startAt, this.endAt, this.breakTypeId, this.name, this.expectedDuration, this.isPaid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModelBreak {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    startAt: ").append(this.toIndentedString(this.startAt)).append("\n");
        sb.append("    endAt: ").append(this.toIndentedString(this.endAt)).append("\n");
        sb.append("    breakTypeId: ").append(this.toIndentedString(this.breakTypeId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    expectedDuration: ").append(this.toIndentedString(this.expectedDuration)).append("\n");
        sb.append("    isPaid: ").append(this.toIndentedString(this.isPaid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

