/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="")
public class ObtainTokenRequest {
    @JsonProperty(value="client_id")
    private String clientId = null;
    @JsonProperty(value="client_secret")
    private String clientSecret = null;
    @JsonProperty(value="code")
    private String code = null;
    @JsonProperty(value="redirect_uri")
    private String redirectUri = null;
    @JsonProperty(value="grant_type")
    private String grantType = null;
    @JsonProperty(value="refresh_token")
    private String refreshToken = null;
    @JsonProperty(value="migration_token")
    private String migrationToken = null;

    public ObtainTokenRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Square-issued ID of your application, available from the [application dashboard](https://connect.squareup.com/apps).")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ObtainTokenRequest clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @ApiModelProperty(required=true, value="The Square-issued application secret for your application, available from the [application dashboard](https://connect.squareup.com/apps).")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public ObtainTokenRequest code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(value="The authorization code to exchange. This is required if `grant_type` is set to `authorization_code`, to indicate that the application wants to exchange an authorization code for an OAuth access token.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public ObtainTokenRequest redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    @ApiModelProperty(value="The redirect URL assigned in the [application dashboard](https://connect.squareup.com/apps).")
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public ObtainTokenRequest grantType(String grantType) {
        this.grantType = grantType;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the method to request an OAuth access token. Valid values are: `authorization_code`, `refresh_token`, and `migration_token`")
    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public ObtainTokenRequest refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @ApiModelProperty(value="A valid refresh token for generating a new OAuth access token. A valid refresh token is required if `grant_type` is set to `refresh_token` , to indicate the application wants a replacement for an expired OAuth access token.")
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public ObtainTokenRequest migrationToken(String migrationToken) {
        this.migrationToken = migrationToken;
        return this;
    }

    @ApiModelProperty(value="Legacy OAuth access token obtained using a Connect API version prior to 2019-03-13. This parameter is required if `grant_type` is set to `migration_token` to indicate that the application wants to get a replacement OAuth access token. The response also returns a refresh token. For more information, see [Migrate to Using Refresh Tokens](/authz/oauth/migration).")
    public String getMigrationToken() {
        return this.migrationToken;
    }

    public void setMigrationToken(String migrationToken) {
        this.migrationToken = migrationToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObtainTokenRequest obtainTokenRequest = (ObtainTokenRequest)o;
        return Objects.equals(this.clientId, obtainTokenRequest.clientId) && Objects.equals(this.clientSecret, obtainTokenRequest.clientSecret) && Objects.equals(this.code, obtainTokenRequest.code) && Objects.equals(this.redirectUri, obtainTokenRequest.redirectUri) && Objects.equals(this.grantType, obtainTokenRequest.grantType) && Objects.equals(this.refreshToken, obtainTokenRequest.refreshToken) && Objects.equals(this.migrationToken, obtainTokenRequest.migrationToken);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.code, this.redirectUri, this.grantType, this.refreshToken, this.migrationToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ObtainTokenRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    redirectUri: ").append(this.toIndentedString(this.redirectUri)).append("\n");
        sb.append("    grantType: ").append(this.toIndentedString(this.grantType)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("    migrationToken: ").append(this.toIndentedString(this.migrationToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

