/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Money;
import com.squareup.connect.models.OrderFulfillment;
import com.squareup.connect.models.OrderLineItem;
import com.squareup.connect.models.OrderLineItemDiscount;
import com.squareup.connect.models.OrderLineItemTax;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Contains all information related to a single order to process with Square, including line items that specify the products to purchase")
public class Order {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="location_id")
    private String locationId = null;
    @JsonProperty(value="reference_id")
    private String referenceId = null;
    @JsonProperty(value="line_items")
    private List<OrderLineItem> lineItems = new ArrayList<OrderLineItem>();
    @JsonProperty(value="taxes")
    private List<OrderLineItemTax> taxes = new ArrayList<OrderLineItemTax>();
    @JsonProperty(value="discounts")
    private List<OrderLineItemDiscount> discounts = new ArrayList<OrderLineItemDiscount>();
    @JsonProperty(value="fulfillments")
    private List<OrderFulfillment> fulfillments = new ArrayList<OrderFulfillment>();
    @JsonProperty(value="total_money")
    private Money totalMoney = null;
    @JsonProperty(value="total_tax_money")
    private Money totalTaxMoney = null;
    @JsonProperty(value="total_discount_money")
    private Money totalDiscountMoney = null;

    public Order id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The order's unique ID.  This value is only present for Order objects created by the Orders API through the [CreateOrder](#endpoint-createorder) endpoint.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Order locationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the merchant location this order is associated with.")
    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public Order referenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    @ApiModelProperty(value="A client specified identifier to associate an entity in another system with this order.")
    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public Order lineItems(List<OrderLineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public Order addLineItemsItem(OrderLineItem lineItemsItem) {
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="The line items included in the order.")
    public List<OrderLineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<OrderLineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public Order taxes(List<OrderLineItemTax> taxes) {
        this.taxes = taxes;
        return this;
    }

    public Order addTaxesItem(OrderLineItemTax taxesItem) {
        this.taxes.add(taxesItem);
        return this;
    }

    @ApiModelProperty(value="A list of taxes applied to this order. On read or retrieve, this list includes both order-level and item-level taxes. When creating an Order, set your order-level taxes in this list.")
    public List<OrderLineItemTax> getTaxes() {
        return this.taxes;
    }

    public void setTaxes(List<OrderLineItemTax> taxes) {
        this.taxes = taxes;
    }

    public Order discounts(List<OrderLineItemDiscount> discounts) {
        this.discounts = discounts;
        return this;
    }

    public Order addDiscountsItem(OrderLineItemDiscount discountsItem) {
        this.discounts.add(discountsItem);
        return this;
    }

    @ApiModelProperty(value="A list of discounts applied to this order. On read or retrieve, this list includes both order-level and item-level discounts. When creating an Order, set your order-level discounts in this list.")
    public List<OrderLineItemDiscount> getDiscounts() {
        return this.discounts;
    }

    public void setDiscounts(List<OrderLineItemDiscount> discounts) {
        this.discounts = discounts;
    }

    public Order fulfillments(List<OrderFulfillment> fulfillments) {
        this.fulfillments = fulfillments;
        return this;
    }

    public Order addFulfillmentsItem(OrderFulfillment fulfillmentsItem) {
        this.fulfillments.add(fulfillmentsItem);
        return this;
    }

    @ApiModelProperty(value="Details on order fulfillment.  Orders can only be created with at most one fulfillment. However, orders returned by the API may contain multiple fulfillments.")
    public List<OrderFulfillment> getFulfillments() {
        return this.fulfillments;
    }

    public void setFulfillments(List<OrderFulfillment> fulfillments) {
        this.fulfillments = fulfillments;
    }

    public Order totalMoney(Money totalMoney) {
        this.totalMoney = totalMoney;
        return this;
    }

    @ApiModelProperty(value="The total amount of money to collect for the order.")
    public Money getTotalMoney() {
        return this.totalMoney;
    }

    public void setTotalMoney(Money totalMoney) {
        this.totalMoney = totalMoney;
    }

    public Order totalTaxMoney(Money totalTaxMoney) {
        this.totalTaxMoney = totalTaxMoney;
        return this;
    }

    @ApiModelProperty(value="The total tax amount of money to collect for the order.")
    public Money getTotalTaxMoney() {
        return this.totalTaxMoney;
    }

    public void setTotalTaxMoney(Money totalTaxMoney) {
        this.totalTaxMoney = totalTaxMoney;
    }

    public Order totalDiscountMoney(Money totalDiscountMoney) {
        this.totalDiscountMoney = totalDiscountMoney;
        return this;
    }

    @ApiModelProperty(value="The total discount amount of money to collect for the order.")
    public Money getTotalDiscountMoney() {
        return this.totalDiscountMoney;
    }

    public void setTotalDiscountMoney(Money totalDiscountMoney) {
        this.totalDiscountMoney = totalDiscountMoney;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Order order = (Order)o;
        return Objects.equals(this.id, order.id) && Objects.equals(this.locationId, order.locationId) && Objects.equals(this.referenceId, order.referenceId) && Objects.equals(this.lineItems, order.lineItems) && Objects.equals(this.taxes, order.taxes) && Objects.equals(this.discounts, order.discounts) && Objects.equals(this.fulfillments, order.fulfillments) && Objects.equals(this.totalMoney, order.totalMoney) && Objects.equals(this.totalTaxMoney, order.totalTaxMoney) && Objects.equals(this.totalDiscountMoney, order.totalDiscountMoney);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.referenceId, this.lineItems, this.taxes, this.discounts, this.fulfillments, this.totalMoney, this.totalTaxMoney, this.totalDiscountMoney);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Order {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    referenceId: ").append(this.toIndentedString(this.referenceId)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    taxes: ").append(this.toIndentedString(this.taxes)).append("\n");
        sb.append("    discounts: ").append(this.toIndentedString(this.discounts)).append("\n");
        sb.append("    fulfillments: ").append(this.toIndentedString(this.fulfillments)).append("\n");
        sb.append("    totalMoney: ").append(this.toIndentedString(this.totalMoney)).append("\n");
        sb.append("    totalTaxMoney: ").append(this.toIndentedString(this.totalTaxMoney)).append("\n");
        sb.append("    totalDiscountMoney: ").append(this.toIndentedString(this.totalDiscountMoney)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

