/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.OrderFulfillmentPickupDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Contains details on how to fulfill this order.")
public class OrderFulfillment {
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="state")
    private StateEnum state = null;
    @JsonProperty(value="pickup_details")
    private OrderFulfillmentPickupDetails pickupDetails = null;

    public OrderFulfillment type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the fulfillment. See [OrderFulfillmentType](#type-orderfulfillmenttype) for possible values")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OrderFulfillment state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="The state of the fulfillment. See [OrderFulfillmentState](#type-orderfulfillmentstate) for possible values")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public OrderFulfillment pickupDetails(OrderFulfillmentPickupDetails pickupDetails) {
        this.pickupDetails = pickupDetails;
        return this;
    }

    @ApiModelProperty(value="Contains pickup-specific details. Required when fulfillment type is `PICKUP`.")
    public OrderFulfillmentPickupDetails getPickupDetails() {
        return this.pickupDetails;
    }

    public void setPickupDetails(OrderFulfillmentPickupDetails pickupDetails) {
        this.pickupDetails = pickupDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderFulfillment orderFulfillment = (OrderFulfillment)o;
        return Objects.equals((Object)this.type, (Object)orderFulfillment.type) && Objects.equals((Object)this.state, (Object)orderFulfillment.state) && Objects.equals(this.pickupDetails, orderFulfillment.pickupDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.state, this.pickupDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderFulfillment {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    pickupDetails: ").append(this.toIndentedString(this.pickupDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        PROPOSED("PROPOSED"),
        RESERVED("RESERVED"),
        PREPARED("PREPARED"),
        COMPLETED("COMPLETED"),
        CANCELED("CANCELED"),
        FAILED("FAILED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TypeEnum {
        PICKUP("PICKUP");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

