/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.OrderFulfillmentRecipient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Contains details necessary to fulfill a pickup order.")
public class OrderFulfillmentPickupDetails {
    @JsonProperty(value="recipient")
    private OrderFulfillmentRecipient recipient = null;
    @JsonProperty(value="expires_at")
    private String expiresAt = null;
    @JsonProperty(value="auto_complete_duration")
    private String autoCompleteDuration = null;
    @JsonProperty(value="schedule_type")
    private ScheduleTypeEnum scheduleType = null;
    @JsonProperty(value="pickup_at")
    private String pickupAt = null;
    @JsonProperty(value="pickup_window_duration")
    private String pickupWindowDuration = null;
    @JsonProperty(value="prep_time_duration")
    private String prepTimeDuration = null;
    @JsonProperty(value="note")
    private String note = null;
    @JsonProperty(value="placed_at")
    private String placedAt = null;
    @JsonProperty(value="accepted_at")
    private String acceptedAt = null;
    @JsonProperty(value="rejected_at")
    private String rejectedAt = null;
    @JsonProperty(value="ready_at")
    private String readyAt = null;
    @JsonProperty(value="expired_at")
    private String expiredAt = null;
    @JsonProperty(value="picked_up_at")
    private String pickedUpAt = null;
    @JsonProperty(value="canceled_at")
    private String canceledAt = null;
    @JsonProperty(value="cancel_reason")
    private String cancelReason = null;

    public OrderFulfillmentPickupDetails recipient(OrderFulfillmentRecipient recipient) {
        this.recipient = recipient;
        return this;
    }

    @ApiModelProperty(value="The recipient of this pickup fulfillment.")
    public OrderFulfillmentRecipient getRecipient() {
        return this.recipient;
    }

    public void setRecipient(OrderFulfillmentRecipient recipient) {
        this.recipient = recipient;
    }

    public OrderFulfillmentPickupDetails expiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @ApiModelProperty(value="The expiry [timestamp](#workingwithdates) in RFC 3339 format, e.g., \"2016-09-04T23:59:33.123Z\". This timestamp indicates when the pickup fulfillment will expire if it is not accepted by the merchant. Expiration time can only be set up to 7 days in the future. If not set, this pickup fulfillment will be automatically accepted when placed.")
    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public OrderFulfillmentPickupDetails autoCompleteDuration(String autoCompleteDuration) {
        this.autoCompleteDuration = autoCompleteDuration;
        return this;
    }

    @ApiModelProperty(value="The auto completion duration in RFC3339 duration format, e.g., \"P1W3D\". If set, an open and accepted pickup fulfillment will automatically move to the `COMPLETED` state after this period of time. If not set, this pickup fulfillment will remain accepted until it is canceled or completed.")
    public String getAutoCompleteDuration() {
        return this.autoCompleteDuration;
    }

    public void setAutoCompleteDuration(String autoCompleteDuration) {
        this.autoCompleteDuration = autoCompleteDuration;
    }

    public OrderFulfillmentPickupDetails scheduleType(ScheduleTypeEnum scheduleType) {
        this.scheduleType = scheduleType;
        return this;
    }

    @ApiModelProperty(value="The schedule type of the pickup fulfillment. Defaults to `SCHEDULED`. See [OrderFulfillmentPickupDetailsScheduleType](#type-orderfulfillmentpickupdetailsscheduletype) for possible values")
    public ScheduleTypeEnum getScheduleType() {
        return this.scheduleType;
    }

    public void setScheduleType(ScheduleTypeEnum scheduleType) {
        this.scheduleType = scheduleType;
    }

    public OrderFulfillmentPickupDetails pickupAt(String pickupAt) {
        this.pickupAt = pickupAt;
        return this;
    }

    @ApiModelProperty(value="The pickup [timestamp](#workingwithdates) in RFC3339 timestamp format, e.g., \"2016-09-04T23:59:33.123Z\". For fulfillments with the schedule type `ASAP`, this is automatically set to the current time plus the expected duration to prepare the fulfillment. This represents the start of the pickup window.")
    public String getPickupAt() {
        return this.pickupAt;
    }

    public void setPickupAt(String pickupAt) {
        this.pickupAt = pickupAt;
    }

    public OrderFulfillmentPickupDetails pickupWindowDuration(String pickupWindowDuration) {
        this.pickupWindowDuration = pickupWindowDuration;
        return this;
    }

    @ApiModelProperty(value="The pickup window duration in RFC3339 duration format, e.g., \"P1W3D\". This duration represents the window of time for which the order should be picked up after the `pickup_at` time. Can be used as an informational guideline for merchants.")
    public String getPickupWindowDuration() {
        return this.pickupWindowDuration;
    }

    public void setPickupWindowDuration(String pickupWindowDuration) {
        this.pickupWindowDuration = pickupWindowDuration;
    }

    public OrderFulfillmentPickupDetails prepTimeDuration(String prepTimeDuration) {
        this.prepTimeDuration = prepTimeDuration;
        return this;
    }

    @ApiModelProperty(value="The preparation time duration in RFC3339 duration format, e.g., \"P1W3D\". This duration indicates how long it takes the merchant to prepare this fulfillment.")
    public String getPrepTimeDuration() {
        return this.prepTimeDuration;
    }

    public void setPrepTimeDuration(String prepTimeDuration) {
        this.prepTimeDuration = prepTimeDuration;
    }

    public OrderFulfillmentPickupDetails note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(value="A general note about the pickup fulfillment.  Notes are useful for providing additional instructions and are displayed in Square apps.")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public OrderFulfillmentPickupDetails placedAt(String placedAt) {
        this.placedAt = placedAt;
        return this;
    }

    @ApiModelProperty(value="The [timestamp](#workingwithdates) in RFC3339 timestamp format, e.g., \"2016-09-04T23:59:33.123Z\", indicating when the fulfillment was placed.")
    public String getPlacedAt() {
        return this.placedAt;
    }

    public void setPlacedAt(String placedAt) {
        this.placedAt = placedAt;
    }

    public OrderFulfillmentPickupDetails acceptedAt(String acceptedAt) {
        this.acceptedAt = acceptedAt;
        return this;
    }

    @ApiModelProperty(value="The [timestamp](#workingwithdates) in RFC3339 timestamp format, e.g., \"2016-09-04T23:59:33.123Z\", indicating when the fulfillment was accepted by the merchant.")
    public String getAcceptedAt() {
        return this.acceptedAt;
    }

    public void setAcceptedAt(String acceptedAt) {
        this.acceptedAt = acceptedAt;
    }

    public OrderFulfillmentPickupDetails rejectedAt(String rejectedAt) {
        this.rejectedAt = rejectedAt;
        return this;
    }

    @ApiModelProperty(value="The [timestamp](#workingwithdates) in RFC3339 timestamp format, e.g., \"2016-09-04T23:59:33.123Z\", indicating when the fulfillment was rejected.")
    public String getRejectedAt() {
        return this.rejectedAt;
    }

    public void setRejectedAt(String rejectedAt) {
        this.rejectedAt = rejectedAt;
    }

    public OrderFulfillmentPickupDetails readyAt(String readyAt) {
        this.readyAt = readyAt;
        return this;
    }

    @ApiModelProperty(value="The [timestamp](#workingwithdates) in RFC3339 timestamp format, e.g., \"2016-09-04T23:59:33.123Z\", indicating when the merchant set the fulfillment as ready for pickup.")
    public String getReadyAt() {
        return this.readyAt;
    }

    public void setReadyAt(String readyAt) {
        this.readyAt = readyAt;
    }

    public OrderFulfillmentPickupDetails expiredAt(String expiredAt) {
        this.expiredAt = expiredAt;
        return this;
    }

    @ApiModelProperty(value="The [timestamp](#workingwithdates) in RFC3339 timestamp format, e.g., \"2016-09-04T23:59:33.123Z\", indicating when the fulfillment expired.")
    public String getExpiredAt() {
        return this.expiredAt;
    }

    public void setExpiredAt(String expiredAt) {
        this.expiredAt = expiredAt;
    }

    public OrderFulfillmentPickupDetails pickedUpAt(String pickedUpAt) {
        this.pickedUpAt = pickedUpAt;
        return this;
    }

    @ApiModelProperty(value="The [timestamp](#workingwithdates) in RFC3339 timestamp format, e.g., \"2016-09-04T23:59:33.123Z\", indicating when the fulfillment was picked up by the recipient.")
    public String getPickedUpAt() {
        return this.pickedUpAt;
    }

    public void setPickedUpAt(String pickedUpAt) {
        this.pickedUpAt = pickedUpAt;
    }

    public OrderFulfillmentPickupDetails canceledAt(String canceledAt) {
        this.canceledAt = canceledAt;
        return this;
    }

    @ApiModelProperty(value="The [timestamp](#workingwithdates) in RFC3339 timestamp format, e.g., \"2016-09-04T23:59:33.123Z\", indicating when the fulfillment was canceled by the merchant or buyer.")
    public String getCanceledAt() {
        return this.canceledAt;
    }

    public void setCanceledAt(String canceledAt) {
        this.canceledAt = canceledAt;
    }

    public OrderFulfillmentPickupDetails cancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
        return this;
    }

    @ApiModelProperty(value="A description of why the pickup was canceled. Max length is 100 characters.")
    public String getCancelReason() {
        return this.cancelReason;
    }

    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderFulfillmentPickupDetails orderFulfillmentPickupDetails = (OrderFulfillmentPickupDetails)o;
        return Objects.equals(this.recipient, orderFulfillmentPickupDetails.recipient) && Objects.equals(this.expiresAt, orderFulfillmentPickupDetails.expiresAt) && Objects.equals(this.autoCompleteDuration, orderFulfillmentPickupDetails.autoCompleteDuration) && Objects.equals((Object)this.scheduleType, (Object)orderFulfillmentPickupDetails.scheduleType) && Objects.equals(this.pickupAt, orderFulfillmentPickupDetails.pickupAt) && Objects.equals(this.pickupWindowDuration, orderFulfillmentPickupDetails.pickupWindowDuration) && Objects.equals(this.prepTimeDuration, orderFulfillmentPickupDetails.prepTimeDuration) && Objects.equals(this.note, orderFulfillmentPickupDetails.note) && Objects.equals(this.placedAt, orderFulfillmentPickupDetails.placedAt) && Objects.equals(this.acceptedAt, orderFulfillmentPickupDetails.acceptedAt) && Objects.equals(this.rejectedAt, orderFulfillmentPickupDetails.rejectedAt) && Objects.equals(this.readyAt, orderFulfillmentPickupDetails.readyAt) && Objects.equals(this.expiredAt, orderFulfillmentPickupDetails.expiredAt) && Objects.equals(this.pickedUpAt, orderFulfillmentPickupDetails.pickedUpAt) && Objects.equals(this.canceledAt, orderFulfillmentPickupDetails.canceledAt) && Objects.equals(this.cancelReason, orderFulfillmentPickupDetails.cancelReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.recipient, this.expiresAt, this.autoCompleteDuration, this.scheduleType, this.pickupAt, this.pickupWindowDuration, this.prepTimeDuration, this.note, this.placedAt, this.acceptedAt, this.rejectedAt, this.readyAt, this.expiredAt, this.pickedUpAt, this.canceledAt, this.cancelReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderFulfillmentPickupDetails {\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    autoCompleteDuration: ").append(this.toIndentedString(this.autoCompleteDuration)).append("\n");
        sb.append("    scheduleType: ").append(this.toIndentedString((Object)this.scheduleType)).append("\n");
        sb.append("    pickupAt: ").append(this.toIndentedString(this.pickupAt)).append("\n");
        sb.append("    pickupWindowDuration: ").append(this.toIndentedString(this.pickupWindowDuration)).append("\n");
        sb.append("    prepTimeDuration: ").append(this.toIndentedString(this.prepTimeDuration)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    placedAt: ").append(this.toIndentedString(this.placedAt)).append("\n");
        sb.append("    acceptedAt: ").append(this.toIndentedString(this.acceptedAt)).append("\n");
        sb.append("    rejectedAt: ").append(this.toIndentedString(this.rejectedAt)).append("\n");
        sb.append("    readyAt: ").append(this.toIndentedString(this.readyAt)).append("\n");
        sb.append("    expiredAt: ").append(this.toIndentedString(this.expiredAt)).append("\n");
        sb.append("    pickedUpAt: ").append(this.toIndentedString(this.pickedUpAt)).append("\n");
        sb.append("    canceledAt: ").append(this.toIndentedString(this.canceledAt)).append("\n");
        sb.append("    cancelReason: ").append(this.toIndentedString(this.cancelReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ScheduleTypeEnum {
        SCHEDULED("SCHEDULED"),
        ASAP("ASAP");

        private String value;

        private ScheduleTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScheduleTypeEnum fromValue(String text) {
            for (ScheduleTypeEnum b : ScheduleTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

