/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The recipient of a fulfillment.")
public class OrderFulfillmentRecipient {
    @JsonProperty(value="customer_id")
    private String customerId = null;
    @JsonProperty(value="display_name")
    private String displayName = null;
    @JsonProperty(value="email_address")
    private String emailAddress = null;
    @JsonProperty(value="phone_number")
    private String phoneNumber = null;

    public OrderFulfillmentRecipient customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    @ApiModelProperty(value="The Customer ID of the customer associated with the fulfillment.  If customer_id is provided, the corresponding recipient information fields (`display_name`, `email_address`, and `phone_number`) are automatically populated from the relevant customer profile. If the targeted profile information does not contain the necessary required information, the request will result in an error.")
    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public OrderFulfillmentRecipient displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="The display name of the fulfillment recipient.  If provided, overrides the value from customer profile indicated by customer_id.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public OrderFulfillmentRecipient emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @ApiModelProperty(value="The email address of the fulfillment recipient.  If provided, overrides the value from customer profile indicated by customer_id.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public OrderFulfillmentRecipient phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="The phone number of the fulfillment recipient.  If provided, overrides the value from customer profile indicated by customer_id.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderFulfillmentRecipient orderFulfillmentRecipient = (OrderFulfillmentRecipient)o;
        return Objects.equals(this.customerId, orderFulfillmentRecipient.customerId) && Objects.equals(this.displayName, orderFulfillmentRecipient.displayName) && Objects.equals(this.emailAddress, orderFulfillmentRecipient.emailAddress) && Objects.equals(this.phoneNumber, orderFulfillmentRecipient.phoneNumber);
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.displayName, this.emailAddress, this.phoneNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderFulfillmentRecipient {\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

