/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a discount that applies to one or more line items in an order.  Fixed-amount, order-level discounts are distributed across all non-zero line item totals. The amount distributed to each line item is relative to that item\u2019s contribution to the order subtotal.")
public class OrderLineItemDiscount {
    @JsonProperty(value="catalog_object_id")
    private String catalogObjectId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="percentage")
    private String percentage = null;
    @JsonProperty(value="amount_money")
    private Money amountMoney = null;
    @JsonProperty(value="applied_money")
    private Money appliedMoney = null;
    @JsonProperty(value="scope")
    private ScopeEnum scope = null;

    public OrderLineItemDiscount catalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
        return this;
    }

    @ApiModelProperty(value="The catalog object id referencing [CatalogDiscount](#type-catalogdiscount).")
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    public void setCatalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
    }

    public OrderLineItemDiscount name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The discount's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OrderLineItemDiscount type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the discount. If it is created by API, it would be either `FIXED_PERCENTAGE` or `FIXED_AMOUNT`.  VARIABLE_* is not supported in API because the order is created at the time of sale and either percentage or amount has to be specified. See [OrderLineItemDiscountType](#type-orderlineitemdiscounttype) for possible values")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OrderLineItemDiscount percentage(String percentage) {
        this.percentage = percentage;
        return this;
    }

    @ApiModelProperty(value="The percentage of the tax, as a string representation of a decimal number. A value of `7.25` corresponds to a percentage of 7.25%.  The percentage won't be set for an amount-based discount.")
    public String getPercentage() {
        return this.percentage;
    }

    public void setPercentage(String percentage) {
        this.percentage = percentage;
    }

    public OrderLineItemDiscount amountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
        return this;
    }

    @ApiModelProperty(value="The total monetary amount of the applicable discount. If it is at order level, it is the value of the order level discount. If it is at line item level, it is the value of the line item level discount.  The amount_money won't be set for a percentage-based discount.")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public void setAmountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
    }

    public OrderLineItemDiscount appliedMoney(Money appliedMoney) {
        this.appliedMoney = appliedMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of discount actually applied to this line item.  Represents the amount of money applied to a line item as a discount When an amount-based discount is at order-level, this value is different from `amount_money` because the discount is distributed across the line items.")
    public Money getAppliedMoney() {
        return this.appliedMoney;
    }

    public void setAppliedMoney(Money appliedMoney) {
        this.appliedMoney = appliedMoney;
    }

    public OrderLineItemDiscount scope(ScopeEnum scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(value="Indicates the level at which the discount applies. This field is set by the server. If set in a CreateOrder request, it will be ignored on write. See [OrderLineItemDiscountScope](#type-orderlineitemdiscountscope) for possible values")
    public ScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderLineItemDiscount orderLineItemDiscount = (OrderLineItemDiscount)o;
        return Objects.equals(this.catalogObjectId, orderLineItemDiscount.catalogObjectId) && Objects.equals(this.name, orderLineItemDiscount.name) && Objects.equals((Object)this.type, (Object)orderLineItemDiscount.type) && Objects.equals(this.percentage, orderLineItemDiscount.percentage) && Objects.equals(this.amountMoney, orderLineItemDiscount.amountMoney) && Objects.equals(this.appliedMoney, orderLineItemDiscount.appliedMoney) && Objects.equals((Object)this.scope, (Object)orderLineItemDiscount.scope);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.catalogObjectId, this.name, this.type, this.percentage, this.amountMoney, this.appliedMoney, this.scope});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderLineItemDiscount {\n");
        sb.append("    catalogObjectId: ").append(this.toIndentedString(this.catalogObjectId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    amountMoney: ").append(this.toIndentedString(this.amountMoney)).append("\n");
        sb.append("    appliedMoney: ").append(this.toIndentedString(this.appliedMoney)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString((Object)this.scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ScopeEnum {
        OTHER_DISCOUNT_SCOPE("OTHER_DISCOUNT_SCOPE"),
        LINE_ITEM("LINE_ITEM"),
        ORDER("ORDER");

        private String value;

        private ScopeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScopeEnum fromValue(String text) {
            for (ScopeEnum b : ScopeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TypeEnum {
        UNKNOWN_DISCOUNT("UNKNOWN_DISCOUNT"),
        FIXED_PERCENTAGE("FIXED_PERCENTAGE"),
        FIXED_AMOUNT("FIXED_AMOUNT"),
        VARIABLE_PERCENTAGE("VARIABLE_PERCENTAGE"),
        VARIABLE_AMOUNT("VARIABLE_AMOUNT");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

