/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.CatalogObject;
import com.squareup.connect.models.Error;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class SearchCatalogObjectsResponse {
    @JsonProperty(value="errors")
    private List<Error> errors = new ArrayList<Error>();
    @JsonProperty(value="cursor")
    private String cursor = null;
    @JsonProperty(value="objects")
    private List<CatalogObject> objects = new ArrayList<CatalogObject>();
    @JsonProperty(value="related_objects")
    private List<CatalogObject> relatedObjects = new ArrayList<CatalogObject>();

    public SearchCatalogObjectsResponse errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public SearchCatalogObjectsResponse addErrorsItem(Error errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="The set of [Error](#type-error)s encountered.")
    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public SearchCatalogObjectsResponse cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @ApiModelProperty(value="The pagination cursor to be used in a subsequent request. If unset, this is the final response. See [Pagination](/basics/api101/pagination) for more information.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public SearchCatalogObjectsResponse objects(List<CatalogObject> objects) {
        this.objects = objects;
        return this;
    }

    public SearchCatalogObjectsResponse addObjectsItem(CatalogObject objectsItem) {
        this.objects.add(objectsItem);
        return this;
    }

    @ApiModelProperty(value="The [CatalogObject](#type-catalogobject)s returned.")
    public List<CatalogObject> getObjects() {
        return this.objects;
    }

    public void setObjects(List<CatalogObject> objects) {
        this.objects = objects;
    }

    public SearchCatalogObjectsResponse relatedObjects(List<CatalogObject> relatedObjects) {
        this.relatedObjects = relatedObjects;
        return this;
    }

    public SearchCatalogObjectsResponse addRelatedObjectsItem(CatalogObject relatedObjectsItem) {
        this.relatedObjects.add(relatedObjectsItem);
        return this;
    }

    @ApiModelProperty(value="A list of [CatalogObject](#type-catalogobject)s referenced by the objects in the `objects` field.")
    public List<CatalogObject> getRelatedObjects() {
        return this.relatedObjects;
    }

    public void setRelatedObjects(List<CatalogObject> relatedObjects) {
        this.relatedObjects = relatedObjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchCatalogObjectsResponse searchCatalogObjectsResponse = (SearchCatalogObjectsResponse)o;
        return Objects.equals(this.errors, searchCatalogObjectsResponse.errors) && Objects.equals(this.cursor, searchCatalogObjectsResponse.cursor) && Objects.equals(this.objects, searchCatalogObjectsResponse.objects) && Objects.equals(this.relatedObjects, searchCatalogObjectsResponse.relatedObjects);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.cursor, this.objects, this.relatedObjects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchCatalogObjectsResponse {\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("    objects: ").append(this.toIndentedString(this.objects)).append("\n");
        sb.append("    relatedObjects: ").append(this.toIndentedString(this.relatedObjects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

