/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Customer;
import com.squareup.connect.models.Error;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines the fields that are included in the response body of a request to the [SearchCustomers](#endpoint-searchcustomers) endpoint.  One of `errors` or `customers` is present in a given response (never both).")
public class SearchCustomersResponse {
    @JsonProperty(value="errors")
    private List<Error> errors = new ArrayList<Error>();
    @JsonProperty(value="customers")
    private List<Customer> customers = new ArrayList<Customer>();
    @JsonProperty(value="cursor")
    private String cursor = null;

    public SearchCustomersResponse errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public SearchCustomersResponse addErrorsItem(Error errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="Any errors that occurred during the request.")
    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public SearchCustomersResponse customers(List<Customer> customers) {
        this.customers = customers;
        return this;
    }

    public SearchCustomersResponse addCustomersItem(Customer customersItem) {
        this.customers.add(customersItem);
        return this;
    }

    @ApiModelProperty(value="An array of `Customer` objects that match a query.")
    public List<Customer> getCustomers() {
        return this.customers;
    }

    public void setCustomers(List<Customer> customers) {
        this.customers = customers;
    }

    public SearchCustomersResponse cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @ApiModelProperty(value="A pagination cursor that can be used during subsequent calls to SearchCustomers to retrieve the next set of results associated with the original query. Pagination cursors are only present when a request succeeds and additional results are available.  See [Pagination](/basics/api101/pagination) for more information.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchCustomersResponse searchCustomersResponse = (SearchCustomersResponse)o;
        return Objects.equals(this.errors, searchCustomersResponse.errors) && Objects.equals(this.customers, searchCustomersResponse.customers) && Objects.equals(this.cursor, searchCustomersResponse.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.customers, this.cursor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchCustomersResponse {\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    customers: ").append(this.toIndentedString(this.customers)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

