/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Error;
import com.squareup.connect.models.Shift;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The response to a request for `Shift` objects. Contains the requested `Shift` objects. May contain a set of `Error` objects if the request resulted in errors.")
public class SearchShiftsResponse {
    @JsonProperty(value="shifts")
    private List<Shift> shifts = new ArrayList<Shift>();
    @JsonProperty(value="cursor")
    private String cursor = null;
    @JsonProperty(value="errors")
    private List<Error> errors = new ArrayList<Error>();

    public SearchShiftsResponse shifts(List<Shift> shifts) {
        this.shifts = shifts;
        return this;
    }

    public SearchShiftsResponse addShiftsItem(Shift shiftsItem) {
        this.shifts.add(shiftsItem);
        return this;
    }

    @ApiModelProperty(value="Shifts")
    public List<Shift> getShifts() {
        return this.shifts;
    }

    public void setShifts(List<Shift> shifts) {
        this.shifts = shifts;
    }

    public SearchShiftsResponse cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @ApiModelProperty(value="Opaque cursor for fetching the next page.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public SearchShiftsResponse errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public SearchShiftsResponse addErrorsItem(Error errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="Any errors that occurred during the request.")
    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShiftsResponse searchShiftsResponse = (SearchShiftsResponse)o;
        return Objects.equals(this.shifts, searchShiftsResponse.shifts) && Objects.equals(this.cursor, searchShiftsResponse.cursor) && Objects.equals(this.errors, searchShiftsResponse.errors);
    }

    public int hashCode() {
        return Objects.hash(this.shifts, this.cursor, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchShiftsResponse {\n");
        sb.append("    shifts: ").append(this.toIndentedString(this.shifts)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

