/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.ModelBreak;
import com.squareup.connect.models.ShiftWage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A record of the hourly rate, start, and end times for a single work shift  for an employee. May include a record of the start and end times for breaks  taken during the shift.")
public class Shift {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="employee_id")
    private String employeeId = null;
    @JsonProperty(value="location_id")
    private String locationId = null;
    @JsonProperty(value="timezone")
    private String timezone = null;
    @JsonProperty(value="start_at")
    private String startAt = null;
    @JsonProperty(value="end_at")
    private String endAt = null;
    @JsonProperty(value="wage")
    private ShiftWage wage = null;
    @JsonProperty(value="breaks")
    private List<ModelBreak> breaks = new ArrayList<ModelBreak>();
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="version")
    private Integer version = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="updated_at")
    private String updatedAt = null;

    public Shift id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="UUID for this object")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Shift employeeId(String employeeId) {
        this.employeeId = employeeId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the employee this shift belongs to.")
    public String getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public Shift locationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    @ApiModelProperty(value="The ID of the location this shift occurred at. Should be based on where the employee clocked in.")
    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public Shift timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @ApiModelProperty(value="Read-only convenience value that is calculated from the location based on `location_id`. Format: the IANA Timezone Database identifier for the location timezone.")
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public Shift startAt(String startAt) {
        this.startAt = startAt;
        return this;
    }

    @ApiModelProperty(required=true, value="RFC 3339; shifted to location timezone + offset. Precision up to the minute is respected; seconds are truncated.")
    public String getStartAt() {
        return this.startAt;
    }

    public void setStartAt(String startAt) {
        this.startAt = startAt;
    }

    public Shift endAt(String endAt) {
        this.endAt = endAt;
        return this;
    }

    @ApiModelProperty(value="RFC 3339; shifted to timezone + offset. Precision up to the minute is respected; seconds are truncated. The `end_at` minute is not counted when the shift length is calculated. For example, a shift from `00:00` to `08:01` is considered an 8 hour shift (midnight to 8am).")
    public String getEndAt() {
        return this.endAt;
    }

    public void setEndAt(String endAt) {
        this.endAt = endAt;
    }

    public Shift wage(ShiftWage wage) {
        this.wage = wage;
        return this;
    }

    @ApiModelProperty(value="Job and pay related information.")
    public ShiftWage getWage() {
        return this.wage;
    }

    public void setWage(ShiftWage wage) {
        this.wage = wage;
    }

    public Shift breaks(List<ModelBreak> breaks) {
        this.breaks = breaks;
        return this;
    }

    public Shift addBreaksItem(ModelBreak breaksItem) {
        this.breaks.add(breaksItem);
        return this;
    }

    @ApiModelProperty(value="A list of any paid or unpaid breaks that were taken during this shift.")
    public List<ModelBreak> getBreaks() {
        return this.breaks;
    }

    public void setBreaks(List<ModelBreak> breaks) {
        this.breaks = breaks;
    }

    public Shift status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Describes working state of the current `Shift`. See [ShiftStatus](#type-shiftstatus) for possible values")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Shift version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="Used for resolving concurrency issues; request will fail if version provided does not match server version at time of request. If not provided, Square executes a blind write; potentially overwriting data from another write.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Shift createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="A read-only timestamp in RFC 3339 format; presented in UTC.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Shift updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="A read-only timestamp in RFC 3339 format; presented in UTC.")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shift shift = (Shift)o;
        return Objects.equals(this.id, shift.id) && Objects.equals(this.employeeId, shift.employeeId) && Objects.equals(this.locationId, shift.locationId) && Objects.equals(this.timezone, shift.timezone) && Objects.equals(this.startAt, shift.startAt) && Objects.equals(this.endAt, shift.endAt) && Objects.equals(this.wage, shift.wage) && Objects.equals(this.breaks, shift.breaks) && Objects.equals((Object)this.status, (Object)shift.status) && Objects.equals(this.version, shift.version) && Objects.equals(this.createdAt, shift.createdAt) && Objects.equals(this.updatedAt, shift.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.employeeId, this.locationId, this.timezone, this.startAt, this.endAt, this.wage, this.breaks, this.status, this.version, this.createdAt, this.updatedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Shift {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    employeeId: ").append(this.toIndentedString(this.employeeId)).append("\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    startAt: ").append(this.toIndentedString(this.startAt)).append("\n");
        sb.append("    endAt: ").append(this.toIndentedString(this.endAt)).append("\n");
        sb.append("    wage: ").append(this.toIndentedString(this.wage)).append("\n");
        sb.append("    breaks: ").append(this.toIndentedString(this.breaks)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        OPEN("OPEN"),
        CLOSED("CLOSED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

