/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.ShiftWorkday;
import com.squareup.connect.models.TimeRange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines a filter used in a search for `Shift` records. `AND` logic is used by Square's servers to apply each filter property specified.")
public class ShiftFilter {
    @JsonProperty(value="location_id")
    private List<String> locationId = new ArrayList<String>();
    @JsonProperty(value="employee_id")
    private List<String> employeeId = new ArrayList<String>();
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="start")
    private TimeRange start = null;
    @JsonProperty(value="end")
    private TimeRange end = null;
    @JsonProperty(value="workday")
    private ShiftWorkday workday = null;

    public ShiftFilter locationId(List<String> locationId) {
        this.locationId = locationId;
        return this;
    }

    public ShiftFilter addLocationIdItem(String locationIdItem) {
        this.locationId.add(locationIdItem);
        return this;
    }

    @ApiModelProperty(value="Fetch shifts for the specified location.")
    public List<String> getLocationId() {
        return this.locationId;
    }

    public void setLocationId(List<String> locationId) {
        this.locationId = locationId;
    }

    public ShiftFilter employeeId(List<String> employeeId) {
        this.employeeId = employeeId;
        return this;
    }

    public ShiftFilter addEmployeeIdItem(String employeeIdItem) {
        this.employeeId.add(employeeIdItem);
        return this;
    }

    @ApiModelProperty(value="Fetch shifts for the specified employee.")
    public List<String> getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(List<String> employeeId) {
        this.employeeId = employeeId;
    }

    public ShiftFilter status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Fetch a `Shift` instance by `Shift.status`. See [ShiftFilterStatus](#type-shiftfilterstatus) for possible values")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ShiftFilter start(TimeRange start) {
        this.start = start;
        return this;
    }

    @ApiModelProperty(value="Fetch `Shift`s that start in the time range - Inclusive.")
    public TimeRange getStart() {
        return this.start;
    }

    public void setStart(TimeRange start) {
        this.start = start;
    }

    public ShiftFilter end(TimeRange end) {
        this.end = end;
        return this;
    }

    @ApiModelProperty(value="Fetch the `Shift`s that end in the time range - Inclusive.")
    public TimeRange getEnd() {
        return this.end;
    }

    public void setEnd(TimeRange end) {
        this.end = end;
    }

    public ShiftFilter workday(ShiftWorkday workday) {
        this.workday = workday;
        return this;
    }

    @ApiModelProperty(value="Fetch the `Shift`s based on workday date range.")
    public ShiftWorkday getWorkday() {
        return this.workday;
    }

    public void setWorkday(ShiftWorkday workday) {
        this.workday = workday;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftFilter shiftFilter = (ShiftFilter)o;
        return Objects.equals(this.locationId, shiftFilter.locationId) && Objects.equals(this.employeeId, shiftFilter.employeeId) && Objects.equals((Object)this.status, (Object)shiftFilter.status) && Objects.equals(this.start, shiftFilter.start) && Objects.equals(this.end, shiftFilter.end) && Objects.equals(this.workday, shiftFilter.workday);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.locationId, this.employeeId, this.status, this.start, this.end, this.workday});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShiftFilter {\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    employeeId: ").append(this.toIndentedString(this.employeeId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    workday: ").append(this.toIndentedString(this.workday)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        OPEN("OPEN"),
        CLOSED("CLOSED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

