/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Sets the sort order of search results.")
public class ShiftSort {
    @JsonProperty(value="field")
    private FieldEnum field = null;
    @JsonProperty(value="order")
    private OrderEnum order = null;

    public ShiftSort field(FieldEnum field) {
        this.field = field;
        return this;
    }

    @ApiModelProperty(value="The field to sort on. See [ShiftSortField](#type-shiftsortfield) for possible values")
    public FieldEnum getField() {
        return this.field;
    }

    public void setField(FieldEnum field) {
        this.field = field;
    }

    public ShiftSort order(OrderEnum order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(value="The order in which results are returned. Defaults to DESC. See [SortOrder](#type-sortorder) for possible values")
    public OrderEnum getOrder() {
        return this.order;
    }

    public void setOrder(OrderEnum order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftSort shiftSort = (ShiftSort)o;
        return Objects.equals((Object)this.field, (Object)shiftSort.field) && Objects.equals((Object)this.order, (Object)shiftSort.order);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.order});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShiftSort {\n");
        sb.append("    field: ").append(this.toIndentedString((Object)this.field)).append("\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OrderEnum {
        DESC("DESC"),
        ASC("ASC");

        private String value;

        private OrderEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OrderEnum fromValue(String text) {
            for (OrderEnum b : OrderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum FieldEnum {
        START_AT("START_AT"),
        END_AT("END_AT"),
        CREATED_AT("CREATED_AT"),
        UPDATED_AT("UPDATED_AT");

        private String value;

        private FieldEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FieldEnum fromValue(String text) {
            for (FieldEnum b : FieldEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

