/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The hourly wage rate used to compensate an employee for this shift.")
public class ShiftWage {
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="hourly_rate")
    private Money hourlyRate = null;

    public ShiftWage title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="The name of the job performed during this shift. Square labor-reporting UIs may group shifts together by title.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ShiftWage hourlyRate(Money hourlyRate) {
        this.hourlyRate = hourlyRate;
        return this;
    }

    @ApiModelProperty(value="Can be a custom-set hourly wage or the calculated effective hourly wage based on annual wage and hours worked per week.")
    public Money getHourlyRate() {
        return this.hourlyRate;
    }

    public void setHourlyRate(Money hourlyRate) {
        this.hourlyRate = hourlyRate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftWage shiftWage = (ShiftWage)o;
        return Objects.equals(this.title, shiftWage.title) && Objects.equals(this.hourlyRate, shiftWage.hourlyRate);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.hourlyRate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShiftWage {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    hourlyRate: ").append(this.toIndentedString(this.hourlyRate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

