/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.DateRange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A `Shift` search query filter parameter that sets a range of days that  a `Shift` must start or end in before passing the filter condition.")
public class ShiftWorkday {
    @JsonProperty(value="date_range")
    private DateRange dateRange = null;
    @JsonProperty(value="match_shifts_by")
    private MatchShiftsByEnum matchShiftsBy = null;
    @JsonProperty(value="default_timezone")
    private String defaultTimezone = null;

    public ShiftWorkday dateRange(DateRange dateRange) {
        this.dateRange = dateRange;
        return this;
    }

    @ApiModelProperty(value="Dates for fetching the shifts")
    public DateRange getDateRange() {
        return this.dateRange;
    }

    public void setDateRange(DateRange dateRange) {
        this.dateRange = dateRange;
    }

    public ShiftWorkday matchShiftsBy(MatchShiftsByEnum matchShiftsBy) {
        this.matchShiftsBy = matchShiftsBy;
        return this;
    }

    @ApiModelProperty(value="The strategy on which the dates are applied. See [ShiftWorkdayMatcher](#type-shiftworkdaymatcher) for possible values")
    public MatchShiftsByEnum getMatchShiftsBy() {
        return this.matchShiftsBy;
    }

    public void setMatchShiftsBy(MatchShiftsByEnum matchShiftsBy) {
        this.matchShiftsBy = matchShiftsBy;
    }

    public ShiftWorkday defaultTimezone(String defaultTimezone) {
        this.defaultTimezone = defaultTimezone;
        return this;
    }

    @ApiModelProperty(value="Location-specific timezones convert workdays to datetime filters. Every location included in the query must have a timezone, or this field must be provided as a fallback. Format: the IANA timezone database identifier for the relevant timezone.")
    public String getDefaultTimezone() {
        return this.defaultTimezone;
    }

    public void setDefaultTimezone(String defaultTimezone) {
        this.defaultTimezone = defaultTimezone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftWorkday shiftWorkday = (ShiftWorkday)o;
        return Objects.equals(this.dateRange, shiftWorkday.dateRange) && Objects.equals((Object)this.matchShiftsBy, (Object)shiftWorkday.matchShiftsBy) && Objects.equals(this.defaultTimezone, shiftWorkday.defaultTimezone);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateRange, this.matchShiftsBy, this.defaultTimezone});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShiftWorkday {\n");
        sb.append("    dateRange: ").append(this.toIndentedString(this.dateRange)).append("\n");
        sb.append("    matchShiftsBy: ").append(this.toIndentedString((Object)this.matchShiftsBy)).append("\n");
        sb.append("    defaultTimezone: ").append(this.toIndentedString(this.defaultTimezone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MatchShiftsByEnum {
        START_AT("START_AT"),
        END_AT("END_AT"),
        INTERSECTION("INTERSECTION");

        private String value;

        private MatchShiftsByEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MatchShiftsByEnum fromValue(String text) {
            for (MatchShiftsByEnum b : MatchShiftsByEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

