/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Provides information about the application used to generate an inventory change.")
public class SourceApplication {
    @JsonProperty(value="product")
    private ProductEnum product = null;
    @JsonProperty(value="application_id")
    private String applicationId = null;
    @JsonProperty(value="name")
    private String name = null;

    public SourceApplication product(ProductEnum product) {
        this.product = product;
        return this;
    }

    @ApiModelProperty(value="Read-only [Product](#type-product) type for the application. See [Product](#type-product) for possible values")
    public ProductEnum getProduct() {
        return this.product;
    }

    public void setProduct(ProductEnum product) {
        this.product = product;
    }

    public SourceApplication applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @ApiModelProperty(value="Read-only Square ID assigned to the application. Only used for [Product](#type-product) type `EXTERNAL_API`.")
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public SourceApplication name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Read-only display name assigned to the application (e.g. `\"Custom Application\"`, `\"Square POS 4.74 for Android\"`).")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceApplication sourceApplication = (SourceApplication)o;
        return Objects.equals((Object)this.product, (Object)sourceApplication.product) && Objects.equals(this.applicationId, sourceApplication.applicationId) && Objects.equals(this.name, sourceApplication.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.product, this.applicationId, this.name});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceApplication {\n");
        sb.append("    product: ").append(this.toIndentedString((Object)this.product)).append("\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProductEnum {
        SQUARE_POS("SQUARE_POS"),
        EXTERNAL_API("EXTERNAL_API"),
        BILLING("BILLING"),
        APPOINTMENTS("APPOINTMENTS"),
        INVOICES("INVOICES"),
        ONLINE_STORE("ONLINE_STORE"),
        PAYROLL("PAYROLL"),
        DASHBOARD("DASHBOARD"),
        ITEM_LIBRARY_IMPORT("ITEM_LIBRARY_IMPORT"),
        OTHER("OTHER");

        private String value;

        private ProductEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProductEnum fromValue(String text) {
            for (ProductEnum b : ProductEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

