/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.AdditionalRecipient;
import com.squareup.connect.models.Money;
import com.squareup.connect.models.TenderCardDetails;
import com.squareup.connect.models.TenderCashDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a tender (i.e., a method of payment) used in a Square transaction.")
public class Tender {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="location_id")
    private String locationId = null;
    @JsonProperty(value="transaction_id")
    private String transactionId = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="note")
    private String note = null;
    @JsonProperty(value="amount_money")
    private Money amountMoney = null;
    @JsonProperty(value="tip_money")
    private Money tipMoney = null;
    @JsonProperty(value="processing_fee_money")
    private Money processingFeeMoney = null;
    @JsonProperty(value="customer_id")
    private String customerId = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="card_details")
    private TenderCardDetails cardDetails = null;
    @JsonProperty(value="cash_details")
    private TenderCashDetails cashDetails = null;
    @JsonProperty(value="additional_recipients")
    private List<AdditionalRecipient> additionalRecipients = new ArrayList<AdditionalRecipient>();

    public Tender id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The tender's unique ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Tender locationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    @ApiModelProperty(value="The ID of the transaction's associated location.")
    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public Tender transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(value="The ID of the tender's associated transaction.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Tender createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The time when the tender was created, in RFC 3339 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Tender note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(value="An optional note associated with the tender at the time of payment.")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Tender amountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of the tender.")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public void setAmountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
    }

    public Tender tipMoney(Money tipMoney) {
        this.tipMoney = tipMoney;
        return this;
    }

    @ApiModelProperty(value="The tip's amount of the tender.")
    public Money getTipMoney() {
        return this.tipMoney;
    }

    public void setTipMoney(Money tipMoney) {
        this.tipMoney = tipMoney;
    }

    public Tender processingFeeMoney(Money processingFeeMoney) {
        this.processingFeeMoney = processingFeeMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of any Square processing fees applied to the tender.  This field is not immediately populated when a new transaction is created. It is usually available after about ten seconds.")
    public Money getProcessingFeeMoney() {
        return this.processingFeeMoney;
    }

    public void setProcessingFeeMoney(Money processingFeeMoney) {
        this.processingFeeMoney = processingFeeMoney;
    }

    public Tender customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    @ApiModelProperty(value="If the tender is associated with a customer or represents a customer's card on file, this is the ID of the associated customer.")
    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public Tender type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of tender, such as `CARD` or `CASH`. See [TenderType](#type-tendertype) for possible values")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Tender cardDetails(TenderCardDetails cardDetails) {
        this.cardDetails = cardDetails;
        return this;
    }

    @ApiModelProperty(value="The details of the card tender.  This value is present only if the value of `type` is `CARD`.")
    public TenderCardDetails getCardDetails() {
        return this.cardDetails;
    }

    public void setCardDetails(TenderCardDetails cardDetails) {
        this.cardDetails = cardDetails;
    }

    public Tender cashDetails(TenderCashDetails cashDetails) {
        this.cashDetails = cashDetails;
        return this;
    }

    @ApiModelProperty(value="The details of the cash tender.  This value is present only if the value of `type` is `CASH`.")
    public TenderCashDetails getCashDetails() {
        return this.cashDetails;
    }

    public void setCashDetails(TenderCashDetails cashDetails) {
        this.cashDetails = cashDetails;
    }

    public Tender additionalRecipients(List<AdditionalRecipient> additionalRecipients) {
        this.additionalRecipients = additionalRecipients;
        return this;
    }

    public Tender addAdditionalRecipientsItem(AdditionalRecipient additionalRecipientsItem) {
        this.additionalRecipients.add(additionalRecipientsItem);
        return this;
    }

    @ApiModelProperty(value="Additional recipients (other than the merchant) receiving a portion of this tender. For example, fees assessed on the purchase by a third party integration.")
    public List<AdditionalRecipient> getAdditionalRecipients() {
        return this.additionalRecipients;
    }

    public void setAdditionalRecipients(List<AdditionalRecipient> additionalRecipients) {
        this.additionalRecipients = additionalRecipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tender tender = (Tender)o;
        return Objects.equals(this.id, tender.id) && Objects.equals(this.locationId, tender.locationId) && Objects.equals(this.transactionId, tender.transactionId) && Objects.equals(this.createdAt, tender.createdAt) && Objects.equals(this.note, tender.note) && Objects.equals(this.amountMoney, tender.amountMoney) && Objects.equals(this.tipMoney, tender.tipMoney) && Objects.equals(this.processingFeeMoney, tender.processingFeeMoney) && Objects.equals(this.customerId, tender.customerId) && Objects.equals((Object)this.type, (Object)tender.type) && Objects.equals(this.cardDetails, tender.cardDetails) && Objects.equals(this.cashDetails, tender.cashDetails) && Objects.equals(this.additionalRecipients, tender.additionalRecipients);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.locationId, this.transactionId, this.createdAt, this.note, this.amountMoney, this.tipMoney, this.processingFeeMoney, this.customerId, this.type, this.cardDetails, this.cashDetails, this.additionalRecipients});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Tender {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    amountMoney: ").append(this.toIndentedString(this.amountMoney)).append("\n");
        sb.append("    tipMoney: ").append(this.toIndentedString(this.tipMoney)).append("\n");
        sb.append("    processingFeeMoney: ").append(this.toIndentedString(this.processingFeeMoney)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    cardDetails: ").append(this.toIndentedString(this.cardDetails)).append("\n");
        sb.append("    cashDetails: ").append(this.toIndentedString(this.cashDetails)).append("\n");
        sb.append("    additionalRecipients: ").append(this.toIndentedString(this.additionalRecipients)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        CARD("CARD"),
        CASH("CASH"),
        THIRD_PARTY_CARD("THIRD_PARTY_CARD"),
        SQUARE_GIFT_CARD("SQUARE_GIFT_CARD"),
        NO_SALE("NO_SALE"),
        OTHER("OTHER");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

