/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="V1AdjustInventoryRequest")
public class V1AdjustInventoryRequest {
    @JsonProperty(value="quantity_delta")
    private BigDecimal quantityDelta = null;
    @JsonProperty(value="adjustment_type")
    private AdjustmentTypeEnum adjustmentType = null;
    @JsonProperty(value="memo")
    private String memo = null;

    public V1AdjustInventoryRequest quantityDelta(BigDecimal quantityDelta) {
        this.quantityDelta = quantityDelta;
        return this;
    }

    @ApiModelProperty(value="The number to adjust the variation's quantity by.")
    public BigDecimal getQuantityDelta() {
        return this.quantityDelta;
    }

    public void setQuantityDelta(BigDecimal quantityDelta) {
        this.quantityDelta = quantityDelta;
    }

    public V1AdjustInventoryRequest adjustmentType(AdjustmentTypeEnum adjustmentType) {
        this.adjustmentType = adjustmentType;
        return this;
    }

    @ApiModelProperty(value="The reason for the inventory adjustment. See [V1AdjustInventoryRequestAdjustmentType](#type-v1adjustinventoryrequestadjustmenttype) for possible values")
    public AdjustmentTypeEnum getAdjustmentType() {
        return this.adjustmentType;
    }

    public void setAdjustmentType(AdjustmentTypeEnum adjustmentType) {
        this.adjustmentType = adjustmentType;
    }

    public V1AdjustInventoryRequest memo(String memo) {
        this.memo = memo;
        return this;
    }

    @ApiModelProperty(value="A note about the inventory adjustment.")
    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1AdjustInventoryRequest v1AdjustInventoryRequest = (V1AdjustInventoryRequest)o;
        return Objects.equals(this.quantityDelta, v1AdjustInventoryRequest.quantityDelta) && Objects.equals((Object)this.adjustmentType, (Object)v1AdjustInventoryRequest.adjustmentType) && Objects.equals(this.memo, v1AdjustInventoryRequest.memo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.quantityDelta, this.adjustmentType, this.memo});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1AdjustInventoryRequest {\n");
        sb.append("    quantityDelta: ").append(this.toIndentedString(this.quantityDelta)).append("\n");
        sb.append("    adjustmentType: ").append(this.toIndentedString((Object)this.adjustmentType)).append("\n");
        sb.append("    memo: ").append(this.toIndentedString(this.memo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AdjustmentTypeEnum {
        SALE("SALE"),
        RECEIVE_STOCK("RECEIVE_STOCK"),
        MANUAL_ADJUST("MANUAL_ADJUST");

        private String value;

        private AdjustmentTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AdjustmentTypeEnum fromValue(String text) {
            for (AdjustmentTypeEnum b : AdjustmentTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

