/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="V1BankAccount")
public class V1BankAccount {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="merchant_id")
    private String merchantId = null;
    @JsonProperty(value="bank_name")
    private String bankName = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="routing_number")
    private String routingNumber = null;
    @JsonProperty(value="account_number_suffix")
    private String accountNumberSuffix = null;
    @JsonProperty(value="currency_code")
    private String currencyCode = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;

    public V1BankAccount id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The bank account's Square-issued ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1BankAccount merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="The Square-issued ID of the merchant associated with the bank account.")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public V1BankAccount bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @ApiModelProperty(value="The name of the bank that manages the account.")
    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public V1BankAccount name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name associated with the bank account.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1BankAccount routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @ApiModelProperty(value="The bank account's routing number.")
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public V1BankAccount accountNumberSuffix(String accountNumberSuffix) {
        this.accountNumberSuffix = accountNumberSuffix;
        return this;
    }

    @ApiModelProperty(value="The last few digits of the bank account number.")
    public String getAccountNumberSuffix() {
        return this.accountNumberSuffix;
    }

    public void setAccountNumberSuffix(String accountNumberSuffix) {
        this.accountNumberSuffix = accountNumberSuffix;
    }

    public V1BankAccount currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="The currency code of the currency associated with the bank account, in ISO 4217 format. For example, the currency code for US dollars is USD.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public V1BankAccount type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The bank account's type (for example, savings or checking). See [V1BankAccountType](#type-v1bankaccounttype) for possible values")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1BankAccount v1BankAccount = (V1BankAccount)o;
        return Objects.equals(this.id, v1BankAccount.id) && Objects.equals(this.merchantId, v1BankAccount.merchantId) && Objects.equals(this.bankName, v1BankAccount.bankName) && Objects.equals(this.name, v1BankAccount.name) && Objects.equals(this.routingNumber, v1BankAccount.routingNumber) && Objects.equals(this.accountNumberSuffix, v1BankAccount.accountNumberSuffix) && Objects.equals(this.currencyCode, v1BankAccount.currencyCode) && Objects.equals((Object)this.type, (Object)v1BankAccount.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.merchantId, this.bankName, this.name, this.routingNumber, this.accountNumberSuffix, this.currencyCode, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1BankAccount {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    accountNumberSuffix: ").append(this.toIndentedString(this.accountNumberSuffix)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        BUSINESS_CHECKING("BUSINESS_CHECKING"),
        CHECKING("CHECKING"),
        INVESTMENT("INVESTMENT"),
        LOAN("LOAN"),
        SAVINGS("SAVINGS"),
        OTHER("OTHER");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

