/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.V1Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="V1CashDrawerEvent")
public class V1CashDrawerEvent {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="employee_id")
    private String employeeId = null;
    @JsonProperty(value="event_type")
    private EventTypeEnum eventType = null;
    @JsonProperty(value="event_money")
    private V1Money eventMoney = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="description")
    private String description = null;

    public V1CashDrawerEvent id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The event's unique ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1CashDrawerEvent employeeId(String employeeId) {
        this.employeeId = employeeId;
        return this;
    }

    @ApiModelProperty(value="The ID of the employee that created the event.")
    public String getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public V1CashDrawerEvent eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(value="The type of event that occurred. See [V1CashDrawerEventEventType](#type-v1cashdrawereventeventtype) for possible values")
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public V1CashDrawerEvent eventMoney(V1Money eventMoney) {
        this.eventMoney = eventMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of money that was added to or removed from the cash drawer because of the event. This value can be positive (for added money) or negative (for removed money).")
    public V1Money getEventMoney() {
        return this.eventMoney;
    }

    public void setEventMoney(V1Money eventMoney) {
        this.eventMoney = eventMoney;
    }

    public V1CashDrawerEvent createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The time when the event occurred, in ISO 8601 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public V1CashDrawerEvent description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="An optional description of the event, entered by the employee that created it.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CashDrawerEvent v1CashDrawerEvent = (V1CashDrawerEvent)o;
        return Objects.equals(this.id, v1CashDrawerEvent.id) && Objects.equals(this.employeeId, v1CashDrawerEvent.employeeId) && Objects.equals((Object)this.eventType, (Object)v1CashDrawerEvent.eventType) && Objects.equals(this.eventMoney, v1CashDrawerEvent.eventMoney) && Objects.equals(this.createdAt, v1CashDrawerEvent.createdAt) && Objects.equals(this.description, v1CashDrawerEvent.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.employeeId, this.eventType, this.eventMoney, this.createdAt, this.description});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CashDrawerEvent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    employeeId: ").append(this.toIndentedString(this.employeeId)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    eventMoney: ").append(this.toIndentedString(this.eventMoney)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EventTypeEnum {
        NO_SALE("NO_SALE"),
        CASH_TENDER_PAYMENT("CASH_TENDER_PAYMENT"),
        OTHER_TENDER_PAYMENT("OTHER_TENDER_PAYMENT"),
        CASH_TENDER_CANCELED_PAYMENT("CASH_TENDER_CANCELED_PAYMENT"),
        OTHER_TENDER_CANCELED_PAYMENT("OTHER_TENDER_CANCELED_PAYMENT"),
        CASH_TENDER_REFUND("CASH_TENDER_REFUND"),
        OTHER_TENDER_REFUND("OTHER_TENDER_REFUND"),
        PAID_IN("PAID_IN"),
        PAID_OUT("PAID_OUT");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventTypeEnum fromValue(String text) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

