/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Device;
import com.squareup.connect.models.V1CashDrawerEvent;
import com.squareup.connect.models.V1Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="V1CashDrawerShift")
public class V1CashDrawerShift {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="event_type")
    private EventTypeEnum eventType = null;
    @JsonProperty(value="opened_at")
    private String openedAt = null;
    @JsonProperty(value="ended_at")
    private String endedAt = null;
    @JsonProperty(value="closed_at")
    private String closedAt = null;
    @JsonProperty(value="employee_ids")
    private List<String> employeeIds = new ArrayList<String>();
    @JsonProperty(value="opening_employee_id")
    private String openingEmployeeId = null;
    @JsonProperty(value="ending_employee_id")
    private String endingEmployeeId = null;
    @JsonProperty(value="closing_employee_id")
    private String closingEmployeeId = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="starting_cash_money")
    private V1Money startingCashMoney = null;
    @JsonProperty(value="cash_payment_money")
    private V1Money cashPaymentMoney = null;
    @JsonProperty(value="cash_refunds_money")
    private V1Money cashRefundsMoney = null;
    @JsonProperty(value="cash_paid_in_money")
    private V1Money cashPaidInMoney = null;
    @JsonProperty(value="cash_paid_out_money")
    private V1Money cashPaidOutMoney = null;
    @JsonProperty(value="expected_cash_money")
    private V1Money expectedCashMoney = null;
    @JsonProperty(value="closed_cash_money")
    private V1Money closedCashMoney = null;
    @JsonProperty(value="device")
    private Device device = null;
    @JsonProperty(value="events")
    private List<V1CashDrawerEvent> events = new ArrayList<V1CashDrawerEvent>();

    public V1CashDrawerShift id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The shift's unique ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1CashDrawerShift eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(value="The shift's current state. See [V1CashDrawerShiftEventType](#type-v1cashdrawershifteventtype) for possible values")
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public V1CashDrawerShift openedAt(String openedAt) {
        this.openedAt = openedAt;
        return this;
    }

    @ApiModelProperty(value="The time when the shift began, in ISO 8601 format.")
    public String getOpenedAt() {
        return this.openedAt;
    }

    public void setOpenedAt(String openedAt) {
        this.openedAt = openedAt;
    }

    public V1CashDrawerShift endedAt(String endedAt) {
        this.endedAt = endedAt;
        return this;
    }

    @ApiModelProperty(value="The time when the shift ended, in ISO 8601 format.")
    public String getEndedAt() {
        return this.endedAt;
    }

    public void setEndedAt(String endedAt) {
        this.endedAt = endedAt;
    }

    public V1CashDrawerShift closedAt(String closedAt) {
        this.closedAt = closedAt;
        return this;
    }

    @ApiModelProperty(value="The time when the shift was closed, in ISO 8601 format.")
    public String getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(String closedAt) {
        this.closedAt = closedAt;
    }

    public V1CashDrawerShift employeeIds(List<String> employeeIds) {
        this.employeeIds = employeeIds;
        return this;
    }

    public V1CashDrawerShift addEmployeeIdsItem(String employeeIdsItem) {
        this.employeeIds.add(employeeIdsItem);
        return this;
    }

    @ApiModelProperty(value="The IDs of all employees that were logged into Square Register at some point during the cash drawer shift.")
    public List<String> getEmployeeIds() {
        return this.employeeIds;
    }

    public void setEmployeeIds(List<String> employeeIds) {
        this.employeeIds = employeeIds;
    }

    public V1CashDrawerShift openingEmployeeId(String openingEmployeeId) {
        this.openingEmployeeId = openingEmployeeId;
        return this;
    }

    @ApiModelProperty(value="The ID of the employee that started the cash drawer shift.")
    public String getOpeningEmployeeId() {
        return this.openingEmployeeId;
    }

    public void setOpeningEmployeeId(String openingEmployeeId) {
        this.openingEmployeeId = openingEmployeeId;
    }

    public V1CashDrawerShift endingEmployeeId(String endingEmployeeId) {
        this.endingEmployeeId = endingEmployeeId;
        return this;
    }

    @ApiModelProperty(value="The ID of the employee that ended the cash drawer shift.")
    public String getEndingEmployeeId() {
        return this.endingEmployeeId;
    }

    public void setEndingEmployeeId(String endingEmployeeId) {
        this.endingEmployeeId = endingEmployeeId;
    }

    public V1CashDrawerShift closingEmployeeId(String closingEmployeeId) {
        this.closingEmployeeId = closingEmployeeId;
        return this;
    }

    @ApiModelProperty(value="The ID of the employee that closed the cash drawer shift by auditing the cash drawer's contents.")
    public String getClosingEmployeeId() {
        return this.closingEmployeeId;
    }

    public void setClosingEmployeeId(String closingEmployeeId) {
        this.closingEmployeeId = closingEmployeeId;
    }

    public V1CashDrawerShift description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The time when the timecard was created, in ISO 8601 format.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public V1CashDrawerShift startingCashMoney(V1Money startingCashMoney) {
        this.startingCashMoney = startingCashMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of money in the cash drawer at the start of the shift.")
    public V1Money getStartingCashMoney() {
        return this.startingCashMoney;
    }

    public void setStartingCashMoney(V1Money startingCashMoney) {
        this.startingCashMoney = startingCashMoney;
    }

    public V1CashDrawerShift cashPaymentMoney(V1Money cashPaymentMoney) {
        this.cashPaymentMoney = cashPaymentMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of money added to the cash drawer from cash payments.")
    public V1Money getCashPaymentMoney() {
        return this.cashPaymentMoney;
    }

    public void setCashPaymentMoney(V1Money cashPaymentMoney) {
        this.cashPaymentMoney = cashPaymentMoney;
    }

    public V1CashDrawerShift cashRefundsMoney(V1Money cashRefundsMoney) {
        this.cashRefundsMoney = cashRefundsMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of money removed from the cash drawer from cash refunds. This value is always negative or zero.")
    public V1Money getCashRefundsMoney() {
        return this.cashRefundsMoney;
    }

    public void setCashRefundsMoney(V1Money cashRefundsMoney) {
        this.cashRefundsMoney = cashRefundsMoney;
    }

    public V1CashDrawerShift cashPaidInMoney(V1Money cashPaidInMoney) {
        this.cashPaidInMoney = cashPaidInMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of money added to the cash drawer for reasons other than cash payments.")
    public V1Money getCashPaidInMoney() {
        return this.cashPaidInMoney;
    }

    public void setCashPaidInMoney(V1Money cashPaidInMoney) {
        this.cashPaidInMoney = cashPaidInMoney;
    }

    public V1CashDrawerShift cashPaidOutMoney(V1Money cashPaidOutMoney) {
        this.cashPaidOutMoney = cashPaidOutMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of money removed from the cash drawer for reasons other than cash refunds.")
    public V1Money getCashPaidOutMoney() {
        return this.cashPaidOutMoney;
    }

    public void setCashPaidOutMoney(V1Money cashPaidOutMoney) {
        this.cashPaidOutMoney = cashPaidOutMoney;
    }

    public V1CashDrawerShift expectedCashMoney(V1Money expectedCashMoney) {
        this.expectedCashMoney = expectedCashMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of money that should be in the cash drawer at the end of the shift, based on the shift's other money amounts.")
    public V1Money getExpectedCashMoney() {
        return this.expectedCashMoney;
    }

    public void setExpectedCashMoney(V1Money expectedCashMoney) {
        this.expectedCashMoney = expectedCashMoney;
    }

    public V1CashDrawerShift closedCashMoney(V1Money closedCashMoney) {
        this.closedCashMoney = closedCashMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of money found in the cash drawer at the end of the shift by an auditing employee.")
    public V1Money getClosedCashMoney() {
        return this.closedCashMoney;
    }

    public void setClosedCashMoney(V1Money closedCashMoney) {
        this.closedCashMoney = closedCashMoney;
    }

    public V1CashDrawerShift device(Device device) {
        this.device = device;
        return this;
    }

    @ApiModelProperty(value="The device running Square Register that was connected to the cash drawer.")
    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public V1CashDrawerShift events(List<V1CashDrawerEvent> events) {
        this.events = events;
        return this;
    }

    public V1CashDrawerShift addEventsItem(V1CashDrawerEvent eventsItem) {
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(value="All of the events (payments, refunds, and so on) that involved the cash drawer during the shift.")
    public List<V1CashDrawerEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<V1CashDrawerEvent> events) {
        this.events = events;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CashDrawerShift v1CashDrawerShift = (V1CashDrawerShift)o;
        return Objects.equals(this.id, v1CashDrawerShift.id) && Objects.equals((Object)this.eventType, (Object)v1CashDrawerShift.eventType) && Objects.equals(this.openedAt, v1CashDrawerShift.openedAt) && Objects.equals(this.endedAt, v1CashDrawerShift.endedAt) && Objects.equals(this.closedAt, v1CashDrawerShift.closedAt) && Objects.equals(this.employeeIds, v1CashDrawerShift.employeeIds) && Objects.equals(this.openingEmployeeId, v1CashDrawerShift.openingEmployeeId) && Objects.equals(this.endingEmployeeId, v1CashDrawerShift.endingEmployeeId) && Objects.equals(this.closingEmployeeId, v1CashDrawerShift.closingEmployeeId) && Objects.equals(this.description, v1CashDrawerShift.description) && Objects.equals(this.startingCashMoney, v1CashDrawerShift.startingCashMoney) && Objects.equals(this.cashPaymentMoney, v1CashDrawerShift.cashPaymentMoney) && Objects.equals(this.cashRefundsMoney, v1CashDrawerShift.cashRefundsMoney) && Objects.equals(this.cashPaidInMoney, v1CashDrawerShift.cashPaidInMoney) && Objects.equals(this.cashPaidOutMoney, v1CashDrawerShift.cashPaidOutMoney) && Objects.equals(this.expectedCashMoney, v1CashDrawerShift.expectedCashMoney) && Objects.equals(this.closedCashMoney, v1CashDrawerShift.closedCashMoney) && Objects.equals(this.device, v1CashDrawerShift.device) && Objects.equals(this.events, v1CashDrawerShift.events);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.eventType, this.openedAt, this.endedAt, this.closedAt, this.employeeIds, this.openingEmployeeId, this.endingEmployeeId, this.closingEmployeeId, this.description, this.startingCashMoney, this.cashPaymentMoney, this.cashRefundsMoney, this.cashPaidInMoney, this.cashPaidOutMoney, this.expectedCashMoney, this.closedCashMoney, this.device, this.events});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CashDrawerShift {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    openedAt: ").append(this.toIndentedString(this.openedAt)).append("\n");
        sb.append("    endedAt: ").append(this.toIndentedString(this.endedAt)).append("\n");
        sb.append("    closedAt: ").append(this.toIndentedString(this.closedAt)).append("\n");
        sb.append("    employeeIds: ").append(this.toIndentedString(this.employeeIds)).append("\n");
        sb.append("    openingEmployeeId: ").append(this.toIndentedString(this.openingEmployeeId)).append("\n");
        sb.append("    endingEmployeeId: ").append(this.toIndentedString(this.endingEmployeeId)).append("\n");
        sb.append("    closingEmployeeId: ").append(this.toIndentedString(this.closingEmployeeId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    startingCashMoney: ").append(this.toIndentedString(this.startingCashMoney)).append("\n");
        sb.append("    cashPaymentMoney: ").append(this.toIndentedString(this.cashPaymentMoney)).append("\n");
        sb.append("    cashRefundsMoney: ").append(this.toIndentedString(this.cashRefundsMoney)).append("\n");
        sb.append("    cashPaidInMoney: ").append(this.toIndentedString(this.cashPaidInMoney)).append("\n");
        sb.append("    cashPaidOutMoney: ").append(this.toIndentedString(this.cashPaidOutMoney)).append("\n");
        sb.append("    expectedCashMoney: ").append(this.toIndentedString(this.expectedCashMoney)).append("\n");
        sb.append("    closedCashMoney: ").append(this.toIndentedString(this.closedCashMoney)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EventTypeEnum {
        OPEN("OPEN"),
        ENDED("ENDED"),
        CLOSED("CLOSED");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventTypeEnum fromValue(String text) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

