/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents one of a business's employees.")
public class V1Employee {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="first_name")
    private String firstName = null;
    @JsonProperty(value="last_name")
    private String lastName = null;
    @JsonProperty(value="role_ids")
    private List<String> roleIds = new ArrayList<String>();
    @JsonProperty(value="authorized_location_ids")
    private List<String> authorizedLocationIds = new ArrayList<String>();
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="external_id")
    private String externalId = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="updated_at")
    private String updatedAt = null;

    public V1Employee id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The employee's unique ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1Employee firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(required=true, value="The employee's first name.")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public V1Employee lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(required=true, value="The employee's last name.")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public V1Employee roleIds(List<String> roleIds) {
        this.roleIds = roleIds;
        return this;
    }

    public V1Employee addRoleIdsItem(String roleIdsItem) {
        this.roleIds.add(roleIdsItem);
        return this;
    }

    @ApiModelProperty(value="The ids of the employee's associated roles. Currently, you can specify only one or zero roles per employee.")
    public List<String> getRoleIds() {
        return this.roleIds;
    }

    public void setRoleIds(List<String> roleIds) {
        this.roleIds = roleIds;
    }

    public V1Employee authorizedLocationIds(List<String> authorizedLocationIds) {
        this.authorizedLocationIds = authorizedLocationIds;
        return this;
    }

    public V1Employee addAuthorizedLocationIdsItem(String authorizedLocationIdsItem) {
        this.authorizedLocationIds.add(authorizedLocationIdsItem);
        return this;
    }

    @ApiModelProperty(value="The IDs of the locations the employee is allowed to clock in at.")
    public List<String> getAuthorizedLocationIds() {
        return this.authorizedLocationIds;
    }

    public void setAuthorizedLocationIds(List<String> authorizedLocationIds) {
        this.authorizedLocationIds = authorizedLocationIds;
    }

    public V1Employee email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The employee's email address.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public V1Employee status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="CWhether the employee is ACTIVE or INACTIVE. Inactive employees cannot sign in to Square Register.Merchants update this field from the Square Dashboard. See [V1EmployeeStatus](#type-v1employeestatus) for possible values")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public V1Employee externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @ApiModelProperty(value="An ID the merchant can set to associate the employee with an entity in another system.")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public V1Employee createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The time when the employee entity was created, in ISO 8601 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public V1Employee updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="The time when the employee entity was most recently updated, in ISO 8601 format.")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Employee v1Employee = (V1Employee)o;
        return Objects.equals(this.id, v1Employee.id) && Objects.equals(this.firstName, v1Employee.firstName) && Objects.equals(this.lastName, v1Employee.lastName) && Objects.equals(this.roleIds, v1Employee.roleIds) && Objects.equals(this.authorizedLocationIds, v1Employee.authorizedLocationIds) && Objects.equals(this.email, v1Employee.email) && Objects.equals((Object)this.status, (Object)v1Employee.status) && Objects.equals(this.externalId, v1Employee.externalId) && Objects.equals(this.createdAt, v1Employee.createdAt) && Objects.equals(this.updatedAt, v1Employee.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.firstName, this.lastName, this.roleIds, this.authorizedLocationIds, this.email, this.status, this.externalId, this.createdAt, this.updatedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Employee {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    roleIds: ").append(this.toIndentedString(this.roleIds)).append("\n");
        sb.append("    authorizedLocationIds: ").append(this.toIndentedString(this.authorizedLocationIds)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

