/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="")
public class V1ListPaymentsRequest {
    @JsonProperty(value="order")
    private OrderEnum order = null;
    @JsonProperty(value="begin_time")
    private String beginTime = null;
    @JsonProperty(value="end_time")
    private String endTime = null;
    @JsonProperty(value="limit")
    private Integer limit = null;
    @JsonProperty(value="batch_token")
    private String batchToken = null;
    @JsonProperty(value="include_partial")
    private Boolean includePartial = null;

    public V1ListPaymentsRequest order(OrderEnum order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(value="The order in which payments are listed in the response. See [SortOrder](#type-sortorder) for possible values")
    public OrderEnum getOrder() {
        return this.order;
    }

    public void setOrder(OrderEnum order) {
        this.order = order;
    }

    public V1ListPaymentsRequest beginTime(String beginTime) {
        this.beginTime = beginTime;
        return this;
    }

    @ApiModelProperty(value="The beginning of the requested reporting period, in ISO 8601 format. If this value is before January 1, 2013 (2013-01-01T00:00:00Z), this endpoint returns an error. Default value: The current time minus one year.")
    public String getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public V1ListPaymentsRequest endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(value="The end of the requested reporting period, in ISO 8601 format. If this value is more than one year greater than begin_time, this endpoint returns an error. Default value: The current time.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public V1ListPaymentsRequest limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(value="The maximum number of payments to return in a single response. This value cannot exceed 200.")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public V1ListPaymentsRequest batchToken(String batchToken) {
        this.batchToken = batchToken;
        return this;
    }

    @ApiModelProperty(value="A pagination cursor to retrieve the next set of results for your original query to the endpoint.")
    public String getBatchToken() {
        return this.batchToken;
    }

    public void setBatchToken(String batchToken) {
        this.batchToken = batchToken;
    }

    public V1ListPaymentsRequest includePartial(Boolean includePartial) {
        this.includePartial = includePartial;
        return this;
    }

    @ApiModelProperty(value="Indicates whether or not to include partial payments in the response. Partial payments will have the tenders collected so far, but the itemizations will be empty until the payment is completed.")
    public Boolean getIncludePartial() {
        return this.includePartial;
    }

    public void setIncludePartial(Boolean includePartial) {
        this.includePartial = includePartial;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ListPaymentsRequest v1ListPaymentsRequest = (V1ListPaymentsRequest)o;
        return Objects.equals((Object)this.order, (Object)v1ListPaymentsRequest.order) && Objects.equals(this.beginTime, v1ListPaymentsRequest.beginTime) && Objects.equals(this.endTime, v1ListPaymentsRequest.endTime) && Objects.equals(this.limit, v1ListPaymentsRequest.limit) && Objects.equals(this.batchToken, v1ListPaymentsRequest.batchToken) && Objects.equals(this.includePartial, v1ListPaymentsRequest.includePartial);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.order, this.beginTime, this.endTime, this.limit, this.batchToken, this.includePartial});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ListPaymentsRequest {\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("    beginTime: ").append(this.toIndentedString(this.beginTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    batchToken: ").append(this.toIndentedString(this.batchToken)).append("\n");
        sb.append("    includePartial: ").append(this.toIndentedString(this.includePartial)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OrderEnum {
        DESC("DESC"),
        ASC("ASC");

        private String value;

        private OrderEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OrderEnum fromValue(String text) {
            for (OrderEnum b : OrderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

