/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Address;
import com.squareup.connect.models.V1MerchantLocationDetails;
import com.squareup.connect.models.V1PhoneNumber;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines the fields that are included in the response body of a request to the **RetrieveBusiness** endpoint.")
public class V1Merchant {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="account_type")
    private AccountTypeEnum accountType = null;
    @JsonProperty(value="account_capabilities")
    private List<String> accountCapabilities = new ArrayList<String>();
    @JsonProperty(value="country_code")
    private String countryCode = null;
    @JsonProperty(value="language_code")
    private String languageCode = null;
    @JsonProperty(value="currency_code")
    private String currencyCode = null;
    @JsonProperty(value="business_name")
    private String businessName = null;
    @JsonProperty(value="business_address")
    private Address businessAddress = null;
    @JsonProperty(value="business_phone")
    private V1PhoneNumber businessPhone = null;
    @JsonProperty(value="business_type")
    private BusinessTypeEnum businessType = null;
    @JsonProperty(value="shipping_address")
    private Address shippingAddress = null;
    @JsonProperty(value="location_details")
    private V1MerchantLocationDetails locationDetails = null;
    @JsonProperty(value="market_url")
    private String marketUrl = null;

    public V1Merchant id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The merchant account's unique identifier.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1Merchant name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name associated with the merchant account.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1Merchant email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The email address associated with the merchant account.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public V1Merchant accountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the merchant account corresponds to a single-location account (LOCATION) or a business account (BUSINESS). This value is almost always LOCATION. See [V1MerchantAccountType](#type-v1merchantaccounttype) for possible values")
    public AccountTypeEnum getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
    }

    public V1Merchant accountCapabilities(List<String> accountCapabilities) {
        this.accountCapabilities = accountCapabilities;
        return this;
    }

    public V1Merchant addAccountCapabilitiesItem(String accountCapabilitiesItem) {
        this.accountCapabilities.add(accountCapabilitiesItem);
        return this;
    }

    @ApiModelProperty(value="Capabilities that are enabled for the merchant's Square account. Capabilities that are not listed in this array are not enabled for the account.")
    public List<String> getAccountCapabilities() {
        return this.accountCapabilities;
    }

    public void setAccountCapabilities(List<String> accountCapabilities) {
        this.accountCapabilities = accountCapabilities;
    }

    public V1Merchant countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="The country associated with the merchant account, in ISO 3166-1-alpha-2 format.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public V1Merchant languageCode(String languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    @ApiModelProperty(value="The language associated with the merchant account, in BCP 47 format.")
    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public V1Merchant currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="The currency associated with the merchant account, in ISO 4217 format. For example, the currency code for US dollars is USD.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public V1Merchant businessName(String businessName) {
        this.businessName = businessName;
        return this;
    }

    @ApiModelProperty(value="The name of the merchant's business.")
    public String getBusinessName() {
        return this.businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public V1Merchant businessAddress(Address businessAddress) {
        this.businessAddress = businessAddress;
        return this;
    }

    @ApiModelProperty(value="The address of the merchant's business.")
    public Address getBusinessAddress() {
        return this.businessAddress;
    }

    public void setBusinessAddress(Address businessAddress) {
        this.businessAddress = businessAddress;
    }

    public V1Merchant businessPhone(V1PhoneNumber businessPhone) {
        this.businessPhone = businessPhone;
        return this;
    }

    @ApiModelProperty(value="The phone number of the merchant's business.")
    public V1PhoneNumber getBusinessPhone() {
        return this.businessPhone;
    }

    public void setBusinessPhone(V1PhoneNumber businessPhone) {
        this.businessPhone = businessPhone;
    }

    public V1Merchant businessType(BusinessTypeEnum businessType) {
        this.businessType = businessType;
        return this;
    }

    @ApiModelProperty(value="The type of business operated by the merchant. See [V1MerchantBusinessType](#type-v1merchantbusinesstype) for possible values")
    public BusinessTypeEnum getBusinessType() {
        return this.businessType;
    }

    public void setBusinessType(BusinessTypeEnum businessType) {
        this.businessType = businessType;
    }

    public V1Merchant shippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    @ApiModelProperty(value="The merchant's shipping address.")
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public V1Merchant locationDetails(V1MerchantLocationDetails locationDetails) {
        this.locationDetails = locationDetails;
        return this;
    }

    @ApiModelProperty(value="Additional information for a single-location account specified by its associated business account, if it has one.")
    public V1MerchantLocationDetails getLocationDetails() {
        return this.locationDetails;
    }

    public void setLocationDetails(V1MerchantLocationDetails locationDetails) {
        this.locationDetails = locationDetails;
    }

    public V1Merchant marketUrl(String marketUrl) {
        this.marketUrl = marketUrl;
        return this;
    }

    @ApiModelProperty(value="The URL of the merchant's online store.")
    public String getMarketUrl() {
        return this.marketUrl;
    }

    public void setMarketUrl(String marketUrl) {
        this.marketUrl = marketUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Merchant v1Merchant = (V1Merchant)o;
        return Objects.equals(this.id, v1Merchant.id) && Objects.equals(this.name, v1Merchant.name) && Objects.equals(this.email, v1Merchant.email) && Objects.equals((Object)this.accountType, (Object)v1Merchant.accountType) && Objects.equals(this.accountCapabilities, v1Merchant.accountCapabilities) && Objects.equals(this.countryCode, v1Merchant.countryCode) && Objects.equals(this.languageCode, v1Merchant.languageCode) && Objects.equals(this.currencyCode, v1Merchant.currencyCode) && Objects.equals(this.businessName, v1Merchant.businessName) && Objects.equals(this.businessAddress, v1Merchant.businessAddress) && Objects.equals(this.businessPhone, v1Merchant.businessPhone) && Objects.equals((Object)this.businessType, (Object)v1Merchant.businessType) && Objects.equals(this.shippingAddress, v1Merchant.shippingAddress) && Objects.equals(this.locationDetails, v1Merchant.locationDetails) && Objects.equals(this.marketUrl, v1Merchant.marketUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.email, this.accountType, this.accountCapabilities, this.countryCode, this.languageCode, this.currencyCode, this.businessName, this.businessAddress, this.businessPhone, this.businessType, this.shippingAddress, this.locationDetails, this.marketUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Merchant {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    accountCapabilities: ").append(this.toIndentedString(this.accountCapabilities)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    languageCode: ").append(this.toIndentedString(this.languageCode)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    businessName: ").append(this.toIndentedString(this.businessName)).append("\n");
        sb.append("    businessAddress: ").append(this.toIndentedString(this.businessAddress)).append("\n");
        sb.append("    businessPhone: ").append(this.toIndentedString(this.businessPhone)).append("\n");
        sb.append("    businessType: ").append(this.toIndentedString((Object)this.businessType)).append("\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    locationDetails: ").append(this.toIndentedString(this.locationDetails)).append("\n");
        sb.append("    marketUrl: ").append(this.toIndentedString(this.marketUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum BusinessTypeEnum {
        ACCOUNTING("ACCOUNTING"),
        APPAREL_AND_ACCESSORY_SHOPS("APPAREL_AND_ACCESSORY_SHOPS"),
        ART_DEALERS_GALLERIES("ART_DEALERS_GALLERIES"),
        ART_DESIGN_AND_PHOTOGRAPHY("ART_DESIGN_AND_PHOTOGRAPHY"),
        BAR_CLUB_LOUNGE("BAR_CLUB_LOUNGE"),
        BEAUTY_AND_BARBER_SHOPS("BEAUTY_AND_BARBER_SHOPS"),
        BOOK_STORES("BOOK_STORES"),
        BUSINESS_SERVICES("BUSINESS_SERVICES"),
        CATERING("CATERING"),
        CHARITABLE_SOCIAL_SERVICE_ORGANIZATIONS("CHARITABLE_SOCIAL_SERVICE_ORGANIZATIONS"),
        CHARITIBLE_ORGS("CHARITIBLE_ORGS"),
        CLEANING_SERVICES("CLEANING_SERVICES"),
        COMPUTER_EQUIPMENT_SOFTWARE_MAINTENANCE_REPAIR_SERVICES("COMPUTER_EQUIPMENT_SOFTWARE_MAINTENANCE_REPAIR_SERVICES"),
        CONSULTANT("CONSULTANT"),
        CONTRACTORS("CONTRACTORS"),
        DELIVERY_SERVICES("DELIVERY_SERVICES"),
        DENTISTRY("DENTISTRY"),
        EDUCATION("EDUCATION"),
        FOOD_STORES_CONVENIENCE_STORES_AND_SPECIALTY_MARKETS("FOOD_STORES_CONVENIENCE_STORES_AND_SPECIALTY_MARKETS"),
        FOOD_TRUCK_CART("FOOD_TRUCK_CART"),
        FURNITURE_HOME_AND_OFFICE_EQUIPMENT("FURNITURE_HOME_AND_OFFICE_EQUIPMENT"),
        FURNITURE_HOME_GOODS("FURNITURE_HOME_GOODS"),
        HOTELS_AND_LODGING("HOTELS_AND_LODGING"),
        INDIVIDUAL_USE("INDIVIDUAL_USE"),
        JEWELRY_AND_WATCHES("JEWELRY_AND_WATCHES"),
        LANDSCAPING_AND_HORTICULTURAL_SERVICES("LANDSCAPING_AND_HORTICULTURAL_SERVICES"),
        LANGUAGE_SCHOOLS("LANGUAGE_SCHOOLS"),
        LEGAL_SERVICES("LEGAL_SERVICES"),
        MEDICAL_PRACTITIONERS("MEDICAL_PRACTITIONERS"),
        MEDICAL_SERVICES_AND_HEALTH_PRACTITIONERS("MEDICAL_SERVICES_AND_HEALTH_PRACTITIONERS"),
        MEMBERSHIP_ORGANIZATIONS("MEMBERSHIP_ORGANIZATIONS"),
        MUSIC_AND_ENTERTAINMENT("MUSIC_AND_ENTERTAINMENT"),
        OTHER("OTHER"),
        OUTDOOR_MARKETS("OUTDOOR_MARKETS"),
        PERSONAL_SERVICES("PERSONAL_SERVICES"),
        POLITICAL_ORGANIZATIONS("POLITICAL_ORGANIZATIONS"),
        PROFESSIONAL_SERVICES("PROFESSIONAL_SERVICES"),
        REAL_ESTATE("REAL_ESTATE"),
        RECREATION_SERVICES("RECREATION_SERVICES"),
        REPAIR_SHOPS_AND_RELATED_SERVICES("REPAIR_SHOPS_AND_RELATED_SERVICES"),
        RESTAURANTS("RESTAURANTS"),
        RETAIL_SHOPS("RETAIL_SHOPS"),
        SCHOOLS_AND_EDUCATIONAL_SERVICES("SCHOOLS_AND_EDUCATIONAL_SERVICES"),
        SPORTING_GOODS("SPORTING_GOODS"),
        TAXICABS_AND_LIMOUSINES("TAXICABS_AND_LIMOUSINES"),
        TICKET_SALES("TICKET_SALES"),
        TOURISM("TOURISM"),
        TRAVEL_TOURISM("TRAVEL_TOURISM"),
        VETERINARY_SERVICES("VETERINARY_SERVICES"),
        WEB_DEV_DESIGN("WEB_DEV_DESIGN");

        private String value;

        private BusinessTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BusinessTypeEnum fromValue(String text) {
            for (BusinessTypeEnum b : BusinessTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum AccountTypeEnum {
        LOCATION("LOCATION"),
        BUSINESS("BUSINESS");

        private String value;

        private AccountTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccountTypeEnum fromValue(String text) {
            for (AccountTypeEnum b : AccountTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

